OPTION LIMROW = 0
OPTION LIMCOL =0

*     SECTION A       SET DEFINITON

 SET  PRODUCT   TABLES CHAIRSSETS    /TABLES, CHAIRS, DINSETS/
      TYPE      TYPES OF PRODUCT     /FUNCTIONAL ,FANCY/
      RESOURCE  TYPES OF RESOURCES /SMLLATHE,LRGLATHE,CARVER,LABOR,TOP/
      METHOD    PRODUCTION METHODS   /NORMAL,MAXSML,MAXLRG/
      PLANT     DIFFERENT PLANTS     /PLANT1, PLANT2, PLANT3/
      SUBPRODUCT(PRODUCT)                /TABLES, CHAIRS/;

*     SECTION B       DATA DEFINITION

 PARAMETER  SETCHAIR(TYPE)  CHAIRS CONTAINED IN EACH SET
                          / FUNCTIONAL 4, FANCY 6/
           TABLECOST(TYPE)  TABLECOST  /FUNCTIONAL 80,FANCY 100/;

 TABLE  CHAIRCOST(METHOD,TYPE) CHAIR COST FOR DIFFERENT METHOD
                               FUNCTIONAL      FANCY
            NORMAL                15            25
            MAXSML                16            25.7
            MAXLRG                16.5          26.6 ;

 TABLE TB1(RESOURCE,TYPE,METHOD)   USE OF RESOURCES IN CHAIR PRODUCTION

            FUNCTIONAL.NORMAL   FUNCTIONAL.MAXSML   FUNCTIONAL.MAXLRG
SMLLATHE          0.8               1.30                0.20
LRGLATHE          0.5               0.20                1.30
CARVER            0.4               0.40                0.40
LABOR             1.0               1.05                1.10
 +

             FANCY.NORMAL       FANCY.MAXSML        FANCY.MAXLRG
SMLLATHE         1.2                1.7                  0.50
LRGLATHE         0.7                0.30                 1.50
CARVER           1.0                1.00                 1.00
LABOR            0.8                0.82                 0.84;

 TABLE TB2(RESOURCE,TYPE)     USE OF RESOURCES IN TABLE PRODUCTION

               FUNCTIONAL     FANCY
   LABOR          3            5
   TOP            1            1;

 TABLE TRANSCOST(SUBPRODUCT, PLANT,TYPE) TRANSPORT COST TO PLANT1

             PLANT1.FUNCTIONAL     PLANT2.FUNCTIONAL  PLANT3.FUNCTIONAL
    CHAIRS                                5               7
    TABLES                                                20
   +
             PLANT1.FANCY     PLANT2.FANCY     PLANT3.FANCY
    CHAIRS                         5                 7
    TABLES                                          20;

 TABLE PRICE(PRODUCT,TYPE) PRICE OF CHAIRS
                  FUNCTIONAL     FANCY
        CHAIRS       82            105
        TABLES      200            300
        DINSETS     600           1100;

 TABLE RESORAVAIL(RESOURCE,PLANT) RESOURCES AVAILABLE
                PLANT1      PLANT2      PLANT3
     TOP          50                      40
     SMLLATHE                 140        130
     LRGLATHE                  90        100
     CARVER                   120        110
     LABOR        175         125        210;

 TABLE ACTIVITY(PRODUCT,PLANT) TELLS IF A PLANT SELLS A PRODUCT
            PLANT1   PLANT2   PLANT3
  TABLES      1                 1
  CHAIRS               1        1
  DINSETS     1                    ;

*   SECTION     C      MODEL  DEFINITION

 POSITIVE VARIABLES
    MAKECHAIR(PLANT, TYPE,METHOD)    NUMBER OF CHAIRS MADE
    MAKETABLE(PLANT, TYPE)           NUMBER OF TABLES MADE
    TRANSPORT(PLANT,SUBPRODUCT,TYPE) NUMBER OF ITEMS TRANSPORTED
    SELL(PLANT,PRODUCT,TYPE)         NUMBER OF ITEMS SOLD
    ARTRES(PLANT,RESOURCE)          Artificial var on resources
 VARIABLES
    NETINCOME                        NET REVENUE (PROFIT);
 EQUATIONS
    OBJT                             OBJECTIVE FUNCTION ( NET REVENUE )
    RESOURCEQ(PLANT,RESOURCE)        RESOURCE LIMITS
    LINKTABLE(TYPE)                  FIRM TABLE LINKAGE CONSTRAINTS
    LINKCHAIR(TYPE)                  FIRM CHAIR LINKAGE CONSTRAINTS
    TRNCHAIREQ(PLANT,TYPE)           CHAIRS BALANCE FOR A PLANT
    TRNTABLEEQ(PLANT,TYPE)           TABLES BALANCE FOR A PLANT;

OBJT..      NETINCOME =E=
  SUM((TYPE, PRODUCT, PLANT)$ACTIVITY(PRODUCT,PLANT),
            PRICE(PRODUCT,TYPE) * SELL(PLANT,PRODUCT,TYPE))
 -SUM((PLANT,TYPE)$ACTIVITY("TABLES",PLANT),
            MAKETABLE(PLANT,TYPE)*TABLECOST(TYPE))
 -SUM((PLANT,TYPE,METHOD)$ACTIVITY("CHAIRS",PLANT),
            MAKECHAIR(PLANT,TYPE,METHOD)* CHAIRCOST(METHOD,TYPE))
 -SUM((PLANT,TYPE,SUBPRODUCT)$TRANSCOST(SUBPRODUCT,PLANT,TYPE),
           TRANSCOST(SUBPRODUCT,PLANT,TYPE)
         * TRANSPORT(PLANT,SUBPRODUCT,TYPE))
 -sum((PLANT,RESOURCE),1000000000*ARTRES(PLANT,RESOURCE)) 
 ;

RESOURCEQ(PLANT,RESOURCE)..
 SUM((TYPE,METHOD)$ACTIVITY("CHAIRS",PLANT),
       TB1(RESOURCE,TYPE,METHOD) * MAKECHAIR(PLANT,TYPE,METHOD))
 +SUM(TYPE$TB2(RESOURCE,TYPE),
       TB2(RESOURCE,TYPE) * MAKETABLE(PLANT,TYPE))
             =l=
  +ARTRES(PLANT,RESOURCE)
  - RESORAVAIL(RESOURCE,PLANT)
  ;

LINKTABLE(TYPE)..
  sUM(PRODUCT$ACTIVITY(PRODUCT,"PLANT1"), SELL("PLANT1",PRODUCT,TYPE))
            =L=
  MAKETABLE("PLANT1",TYPE) +
  SUM(PLANT$TRANSCOST("TABLES",PLANT,TYPE),
          TRANSPORT(PLANT,"TABLES",TYPE));

LINKCHAIR(TYPE)..
  SELL("PLANT1","DINSETS",TYPE) * SETCHAIR(TYPE)
       =L=
  SUM(PLANT$TRANSCOST("CHAIRS",PLANT,TYPE),
       TRANSPORT(PLANT,"CHAIRS",TYPE));

TRNCHAIREQ(PLANT,TYPE)..
  (TRANSPORT(PLANT,"CHAIRS",TYPE) + SELL(PLANT,"CHAIRS",TYPE))
          $TRANSCOST("CHAIRS",PLANT,TYPE)
              =G=
  SUM(METHOD$ACTIVITY("CHAIRS",PLANT),
       MAKECHAIR(PLANT,TYPE,METHOD));

TRNTABLEEQ(PLANT,TYPE)..
  (TRANSPORT(PLANT,"TABLES",TYPE) + SELL(PLANT,"TABLES",TYPE)
  -MAKETABLE(PLANT,TYPE))$TRANSCOST("TABLES",PLANT,TYPE)
              =L= 0 ;
 MODEL FIRM /ALL/;
  SELL.UP(PLANT,PRODUCT,TYPE) =1000000000;
  MAKECHAIR.up(PLANT, TYPE,METHOD) =5000;
 option solprint = on ;
* SECTION D    SOLVE THE PROBLEM
 option lp=gamschk
 SOLVE FIRM USING LP MAXIMIZING NETINCOME;
