﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using GAMS;

namespace Step2
{
    class Step2
    {
        static void Main(string[] args)
        {
            GAMSWorkspace ws = new GAMSWorkspace();
            Cutstock cs = new Cutstock(ws);
            #region prepare data setup in c#
            Dictionary<string, double> d =
                new Dictionary<string, double>() { { "i1", 97 }, { "i2", 610 }, { "i3", 395 }, { "i4", 211 } };
            Dictionary<string, double> w =
                new Dictionary<string, double>() { { "i1", 47 }, { "i2", 36 }, { "i3", 31 }, { "i4", 14 } };
            int r = 100; // raw width
            #endregion
            #region write data into GAMS database
            cs.RawWidth.AddRecord().Value = r;
            foreach (string i in d.Keys)
                cs.Widths.AddRecord(i);
            foreach (KeyValuePair<string, double> t in d)
                cs.Demand.AddRecord(t.Key).Value = t.Value;
            foreach (KeyValuePair<string, double> t in w)
                cs.Width.AddRecord(t.Key).Value = t.Value;
            #endregion
            #region set GAMS options
            cs.Opt.AllModelTypes = "Cplex";
            #endregion
            try
            {
                cs.Run(Console.Out);
                foreach (GAMSParameterRecord rep in cs.PatRep)
                {
                    Console.WriteLine(rep.Keys[0] + ", pattern " + rep.Keys[1] + ": " + rep.Value);
                }
            }
            catch (GAMSException e)
            {
                Console.WriteLine("Problem in GAMS: " + e.Message);
                return;
            }
            catch (System.Exception e)
            {
                Console.WriteLine("System Error: " + e.Message);
                return;
            }
        }
    }
}
