﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace CutStockGUI
{
    public partial class CutWidthsControl : UserControl
    {

        private void maxWidth_ValueChanged(object sender, EventArgs e)
        {
            trackBar.Maximum = (int)((NumericUpDown)sender).Value;
            label.Text = trackBar.Value.ToString();
        }

        public CutWidthsControl(string name, int width, int maxWidth, int demand, Color color, NumericUpDown nudMaxWidth)
        {
            InitializeComponent();
            label1.Text = name;
            this.Name = name;
            trackBar.Maximum = maxWidth;
            trackBar.Value = width;
            nud.Value = demand;
            this.BackColor = color;
            nudMaxWidth.ValueChanged += new System.EventHandler(maxWidth_ValueChanged);
        }

        private void trackBar_ValueChanged(object sender, EventArgs e)
        {
            TrackBar tb = ((TrackBar)sender);
            this.label.Text = tb.Value.ToString();
        }

        public int WidthValue
        {
            get { return trackBar.Value; }
        }

        public int DemandValue
        {
            get { return (int) nud.Value; }
        }
    }
}
