  Sets
       i   canning plants
       j   markets        ;

  Parameters
       a(i)   capacity of plant i in cases
       b(j)   demand at market j in cases
       d(i,j) distance in thousands of miles
       c(i,j) transport cost in thousands of dollars per case ;

  Scalar f  freight in dollars per case per thousand miles;

  Variables
       x(i,j)  shipment quantities in cases
       z       total transportation costs in thousands of dollars ;

  Positive Variable x ;

  Equations
       cost        define objective function
       supply(i)   observe supply limit at plant i
       demand(j)   satisfy demand at market j ;

  cost ..        z  =e=  sum((i,j), c(i,j)*x(i,j)) ;
  supply(i) ..   sum(j, x(i,j))  =l=  a(i) ;
  demand(j) ..   sum(i, x(i,j))  =g=  b(j) ;

  Model transport /all/ ;

$include data.gms

  Solve transport using lp minimizing z ;

display z.l, x.l, x.m;











































$exit
* write data to Excel
execute_unload 'data.gdx';

$onecho > instructions.txt
par=d rng=Sheet1!A1 rdim=1 cdim=1
par=b rng=Sheet1!B6 rdim=0 cdim=1
par=a rng=Sheet1!G2 rdim=1 cdim=0
$offecho
execute 'gdxxrw data.gdx @instructions.txt';
