  Sets
       i   canning plants
       j   markets        ;

  Parameters
       a(i)   capacity of plant i in cases
       b(j)   demand at market j in cases
       d(i,j) distance in thousands of miles
       c(i,j) transport cost in thousands of dollars per case
       f      freight in dollars per case per thousand miles;



  Variables
       x(i,j)  shipment quantities in cases
       z       total transportation costs in thousands of dollars ;

  Positive Variable x ;

  Equations
       cost        define objective function
       supply(i)   observe supply limit at plant i
       demand(j)   satisfy demand at market j ;

  cost ..        z  =e=  sum((i,j), c(i,j)*x(i,j)) ;

  supply(i) ..   sum(j, x(i,j))  =l=  a(i) ;

  demand(j) ..   sum(i, x(i,j))  =g=  b(j) ;

  Model transport /all/ ;

$if not exist data.gdx $call gams data.gms gdx=data
$if errorlevel 1 $abort Error preparing data
$gdxin data.gdx
$load i j a b c d
$gdxin


  Solve transport using lp minimizing z ;
