  Sets
       i   canning plants
       j   markets        ;

  Parameters
       a(i)   capacity of plant i in cases
       b(j)   demand at market j in cases
       d(i,j) distance in thousands of miles
       c(i,j) transport cost in thousands of dollars per case ;



$onecho > instructions.txt
par=d rng=Sheet1!A1 rdim=1 cdim=1
par=b rng=Sheet1!B6 rdim=0 cdim=1
par=a rng=Sheet1!G2 rdim=1 cdim=0
$offecho
$call gdxxrw data.xlsx o=data.gdx @instructions.txt
$if errorlevel 1 $abort Error preparing data


$gdxin data.gdx
$load i<d.dim1 j<d.dim2 d a b
$gdxin


  Scalar f  freight in dollars per case per thousand miles  /90/ ;
  c(i,j) = f * d(i,j) / 1000 ;

  Variables
       x(i,j)  shipment quantities in cases
       z       total transportation costs in thousands of dollars ;

  Positive Variable x ;

  Equations
       cost        define objective function
       supply(i)   observe supply limit at plant i
       demand(j)   satisfy demand at market j ;

  cost ..        z  =e=  sum((i,j), c(i,j)*x(i,j)) ;

  supply(i) ..   sum(j, x(i,j))  =l=  a(i) ;

  demand(j) ..   sum(i, x(i,j))  =g=  b(j) ;

  Model transport /all/ ;

  Solve transport using lp minimizing z ;
