Sets
     i   canning plants
     j   markets        ;

Parameters
     a(i)   capacity of plant i in cases
     b(j)   demand at market j in cases
     d(i,j) distance in thousands of miles
     c(i,j) transport cost in thousands of dollars per case
     f      freight in dollars per case per thousand miles;



Variables
     x(i,j)  shipment quantities in cases
     z       total transportation costs in thousands of dollars ;

Positive Variable x ;

Equations
     cost        define objective function
     supply(i)   observe supply limit at plant i
     demand(j)   satisfy demand at market j ;

cost ..        z  =e=  sum((i,j), c(i,j)*x(i,j)) ;

supply(i) ..   sum(j, x(i,j))  =l=  a(i) ;

demand(j) ..   sum(i, x(i,j))  =g=  b(j) ;

Model transportLP /all/ ;

$call gams data.gms gdx=data
$if errorlevel 1 $abort Error preparing data
$gdxin data.gdx
$load i j a b c d
$gdxin

Solve transportLP using lp minimizing z ;

parameter rep(i,j,*) report shipments;
rep(i,j,'LP') = x.l(i,j);


* MIP


binary variable ship(i,j) '1 if we ship from i to j, otherwise 0';
scalar minS 'minimum shipment' / 100/
       bigM 'Big-M';

equation minship(i,j) minimum shipment
         maxship(i,j) maximum shipment;

minship(i,j).. x(i,j) =g= minS * ship(i,j);
maxship(i,j).. x(i,j) =l= bigM * ship(i,j);

bigM = min(smax(i,a(i)), smax(j,b(j)));


Model transportMIP / transportLP, minship, maxship / ;
option optcr = 0;

Solve transportMIP using MIP minimizing z ;

rep(i,j,'MIP') = x.l(i,j);


* MINLP

Scalar    beta / 0.95 /;

Equation  costnlp define non-linear objective function;
costnlp.. z  =e=  sum((i,j), c(i,j)*x(i,j)**beta) ;


Model transportMINLP / transportMIP - cost + costnlp /;

Solve transportMINLP using MINLP minimizing z ;

rep(i,j,'MINLP') = x.l(i,j);
display rep;
