Sets
   i factories                                   /f1*f3/
   j distribution centers                        /d1*d5/

Parameter
   capacity(i) /f1 500, f2 450, f3 650/
   demand(j)   /d1 160, d2 120, d3 270, d4 325, d5 700 /
   prodcost  unit production cost                   /14/
   price     sales price                            /24/
   wastecost cost of removal of overstocked products /4/

Table transcost(i,j) unit transportation cost
       d1    d2    d3    d4    d5
  f1   2.49  5.21  3.76  4.85  2.07
  f2   1.46  2.54  1.83  1.86  4.76
  f3   3.26  3.08  2.60  3.76  4.45;

Variables
   ship(i,j)   shipments
   product(i)  units produced
   received(j) unit received
   sales(j)    sales (actually sold)
   waste(j)    overstocked products
   profit
Positive variables ship,product,sales,waste;

Equations
   obj
   production(i)
   receive(j)
   selling(j)
   market(j);

obj.. profit =e= sum(j, price*sales(j)) - sum((i,j), transcost(i,j)*ship(i,j))
                 - sum(j, wastecost*waste(j)) - sum(i,prodcost*product(i));

production(i).. product(i) =e= sum(j, ship(i,j));
product.up(i) = capacity(i);

receive(j).. received(j) =e= sum(i, ship(i,j));
selling(j).. sales(j) =e= received(j) - waste(j);
market(j)..  sales(j) =l= demand(j);

model transport /all/;
solve transport maximizing profit using lp;

file emp / '%emp.info%' /; put emp '* problem %gams.i%'/;
$onput
jrandvar demand('d1') demand('d2') demand('d3') demand('d4') demand('d5')
    0.25    150          100          250          300          600
    0.5     160          120          270          325          700
    0.25    170          135          300          350          800
stage 2 demand sales waste profit obj selling market
$offput
putclose emp;

Set scen Scenarios / s1*s3 /;
Parameter
   sc_demand(scen,j)       demand by scenario
   sc_sales(scen,j)        sales by scenario
   sc_waste(scen,j)        waste by scenario
   sc_profit(scen)         profit by scenario;

Set dict / scen         .scenario.''
           demand       .randvar. sc_demand
           sales        .level.   sc_sales
           waste        .level.   sc_waste
           profit       .level.   sc_profit /;

option emp=de;
solve transport maximizing profit using emp scenario dict;
display ship.l, sc_demand, sc_sales, sc_waste, sc_profit;
