Sets
   i factories                                   /f1*f3/
   j distribution centers                        /d1*d5/

Parameter
   capacity(i) /f1 500, f2 450, f3 650/
   demand(j)   /d1 160, d2 120, d3 270, d4 325, d5 700 /
   prodcost  unit production cost                   /14/
   price     sales price                            /24/
   wastecost cost of removal of overstocked products /4/

Table transcost(i,j) unit transportation cost
       d1    d2    d3    d4    d5
  f1   2.49  5.21  3.76  4.85  2.07
  f2   1.46  2.54  1.83  1.86  4.76
  f3   3.26  3.08  2.60  3.76  4.45;

Set
  s scenarios /lo,mid,hi/

table ScenarioData(s,*) possible outcomes for demand plus probabilities
     d1  d2  d3  d4  d5 prob
lo  150 100 250 300 600 0.25
mid 160 120 270 325 700 0.50
hi  170 135 300 350 800 0.25;

* Benders master problem
Set
   iter             max Benders iterations /iter1*iter25/
   dyniter(iter)    growing dynamic subset

Parameter
   cutconst(iter)   constants in optimality cuts
   cutcoeff(iter,j) coefficients in optimality cuts

Variables
   ship(i,j)        shipments
   product(i)       production
   received(j)      quantity sent to market
   zmaster          objective variable of master problem
   theta            future profit
Positive Variables ship;

Equations
   masterobj        master objective function
   production(i)    calculate production in each factory
   receive(j)       calculate quantity to be send to markets
   optcut(iter)     Benders optimality cuts;

masterobj..
    zmaster =e=  theta -sum((i,j), transcost(i,j)*ship(i,j))
                       - sum(i,prodcost*product(i));

receive(j)..       received(j) =e= sum(i, ship(i,j));

production(i)..    product(i) =e= sum(j, ship(i,j));
product.up(i) = capacity(i);

optcut(dyniter)..  theta =l= cutconst(dyniter) +
                             sum(j, cutcoeff(dyniter,j)*received(j));

model masterproblem /all/;

* Benders' subproblem

Variables
   sales(j)         sales (actually sold)
   waste(j)         overstocked products
   zsub             objective variable of sub problem
Positive variables sales, waste

Equations
   subobj           subproblem objective function
   selling(j)       part of received is sold
   market(j)        upperbound on sales
;

subobj..
   zsub =e= sum(j, price*sales(j)) - sum(j, wastecost*waste(j));

selling(j)..  sales(j) + waste(j) =e= received.l(j);

market(j)..   sales(j) =l= demand(j);

model subproblem /subobj,selling,market/;

option limrow=0, limcol=0, solprint=silent, solvelink=%Solvelink.LoadLibrary%;

* Benders algorithm

* solve master without cuts
dyniter(iter) = NO; cutconst(iter) = 0; cutcoeff(iter,j) = 0; theta.fx = 0;
solve masterproblem max zmaster using lp;

* repair theta bounds
theta.lo = -INF; theta.up = INF;

Parameters
   lowerbound /-INF/, upperbound /INF/, done /0/
   objsub(s), p(s), objmaster;
p(s) = ScenarioData(s,'prob');
objmaster = zmaster.l;

loop(iter$(not done),
* solve subproblems
   dyniter(iter) = yes;
   loop(s,
       demand(j) = ScenarioData(s,j);
       solve subproblem max zsub using lp;
       objsub(s) = zsub.l;
       cutconst(iter) = cutconst(iter) + p(s)*sum(j,market.m(j)*demand(j));
       cutcoeff(iter,j) = cutcoeff(iter,j) + p(s)*selling.m(j);
   );
   lowerbound = max(lowerbound, objmaster + sum(s, p(s)*objsub(s)));

* convergence test
   if( (upperbound-lowerbound) < 0.001*(1+abs(upperbound)),
      done = 1;
   else
* solve masterproblem
      solve masterproblem max zmaster using lp;
      upperbound = zmaster.l;
      objmaster = zmaster.l - theta.l;
   );
);
abort$(not done) "Too many iterations";
display zmaster.l, ship.l;