$title SUDOKU model 5

* start with su4, modify data input
* use pricj from map1
* to use gdx for data input

Sets  p  puzzle  / p1*p5 /
      r  rows    / r1*r9 /
      c  columns / c1*c9 /
      b  blocks  / b1*b9 /
      v  values  / v1*v9 /
      br(b,r)    /  b1*b3    .r1*r3,  b4*b6    .r4*r6,  b7*b9    .r7*r9 /
      bc(b,c)    / (b1,b4,b7).c1*c3, (b2,b5,b8).c4*c6, (b3,b6,b9).c7*c9 /
      brc(b,r,c) block definitions
      pprrcc(p,p,r,r,c,c) defines overlapping blocks ;

alias (p,pp),(r,rr),(c,cc);

brc(b,r,c) = br(b,r)*bc(b,c);

pprrcc('p1','p5',r+6,r  ,c+6,c  ) = yes;
pprrcc('p2','p5',r+6,r  ,c  ,c+6) = yes;
pprrcc('p3','p5',r  ,r+6,c+6,c  ) = yes;
pprrcc('p4','p5',r  ,r+6,c  ,c+6) = yes;

$ontext
Table problem(r,c) Hard problem with non-unique solution
    c1   c2   c3   c4   c5   c6   c7   c8   c9
r1   2              6    7
r2            6                    2
r3   4                             8         1
r4   5                        9    3
r5        3                             5
r6             2    8                        7
r7             1
r8   7         8                   6
r9                       5    3              8 ;
$offtext

Parameter problem(p,r,c) Partly filled in cells;

*execseed = frac(jnow)*1e7;
*problem(p,r,c)$(uniform(0,1) < 0.5) = uniformint(1,9);

Binary Variable X(p,r,c,v)    assign value to cell (defined by row and column)
                UNDO(p,r,c,v) undo fixing of cell value;
Variable        W             objectiv value;

equations eq1(p,r,c) exactly one value for each cell
          eq2(p,c,v) columns entries have to be unique
          eq3(p,r,v) row entries have to be unique
          eq4(p,b,v) block entries have to be unique
          eq5(p,p,r,r,c,c,v) force equal cell values in overlap
          fix(p,r,c,v) fix cell values
          fixobj       number of undone cell values;

*X.fx(r,c,v)$(problem(r,c)=ord(v)) = 1;
fix(p,r,c,v)$(problem(p,r,c)=ord(v)).. X(p,r,c,v) =G= 1-UNDO(p,r,c,v);

eq1(p,r,c).. sum(v, X(p,r,c,v))          =E= 1;
eq2(p,c,v).. sum(r, X(p,r,c,v))          =E= 1;
eq3(p,r,v).. sum(c, X(p,r,c,v))          =E= 1;
eq4(p,b,v).. sum(brc(b,r,c), X(p,r,c,v)) =E= 1;

eq5(pprrcc(p,pp,r,rr,c,cc),v).. X(p,r,c,v) =e= X(pp,rr,cc,v);

fixobj..  W =E= sum((p,r,c,v)$(problem(p,r,c)=ord(v)), UNDO(p,r,c,v));

model sudoku / all /;

sets i /i1*i21/
     j /j1*j21/
     pricj(p,r,i,c,j)    maps for 9x9 to 21x21;

pricj('p1',r,i,c,j) = (ord(r)=(ord(i)- 0)) and (ord(c)=(ord(j)- 0));
pricj('p2',r,i,c,j) = (ord(r)=(ord(i)- 0)) and (ord(c)=(ord(j)-12));
pricj('p3',r,i,c,j) = (ord(r)=(ord(i)-12)) and (ord(c)=(ord(j)- 0));
pricj('p4',r,i,c,j) = (ord(r)=(ord(i)-12)) and (ord(c)=(ord(j)-12));
pricj('p5',r,i,c,j) = (ord(r)=(ord(i)- 6)) and (ord(c)=(ord(j)- 6));

parameter big(i,j);
execute_load 'samurai.gdx' big=problem;
loop(pricj(p,r,i,c,j), problem(p,r,c) = big(i,j));

* do not allow any changes
UNDO.fx(p,r,c,v)$problem(p,r,c) = 0;
solve sudoku minimizing w using mip;

if(not(sudoku.modelstat=1 or sudoku.modelstat=8),
   UNDO.up(p,r,c,v)$problem(p,r,c) =  1;
   solve sudoku minimizing w using mip );

abort$(not(sudoku.modelstat=1 or sudoku.modelstat=8)) 'we could not solve this problem';

parameter sol(p,r,c)     complete solution
          qdrep(p,r,c,*) quick & dirty report;

sol(p,r,c) = sum(v, ord(v)*X.l(p,r,c,v));

qdrep(p,r,c,'problem') = problem(p,r,c);
qdrep(p,r,c,'undo.l')  = sum(v$problem(p,r,c), UNDO.l(p,r,c,v));
qdrep(p,r,c,'sol')     = sol(p,r,c);

display  qdrep;

parameter bigsol(i,j);
loop(pricj(p,r,i,c,j),
     bigsol(i,j) = ifthen(problem(p,r,c),problem(p,r,c), - sum(v, ord(v)*x.l(p,r,c,v))));

execute_unload 'solution.gdx' bigsol=solution;
