* column generation model for cutting stock problem

$if not set INGDX  $set INGDX  csDataGG1
$if not set OUTGDX $set OUTGDX csSolGG1

SETS
  i    'cut/finished widths'
  r    'raw/stock widths'
  p    'possible patterns'
  pp(p) 'actual pattern'
  tp(p) 'single pattern'
  pr(p,r) 'actual pattern with its raw width'
  iter  / iter1 * iter999 /
  ;
ALIAS (i,ii), (r,rr);
SCALARS
  nIter  'number of iterations'
  nImp   'number of improving patterns found'
  done / 0 /
  ;
PARAMETERS
  rs(r) 'size of raw widths'
  c(r)  'raw costs'
  gain(r) 'profit from activity pat(i,r)'
  ws(i) 'size of cut widths'
  d(i)  'demand quantities for cut widths'
  u(i)  'marginal prices for pat gen model'
  a(i,p,r) 'count of cut widths i in pattern p from raw r'
  pat(i,r) 'single pattern/activity'
  ;
$gdxin %INGDX%
$loaddc i r p rs c ws d
$gdxin

* start with some trivial patterns
tp('p1') = yes;
loop{(i,r)$[rs(r) >= ws(i)],
  pat(ii,rr) = 0;
  pat(i,r) = floor(rs(r)/ws(i));
  pp(tp) = yes;
  pr(tp,r) = yes;
  a(i,tp,r) = pat(i,r);
  tp(p) = tp(p-1);
};

INTEGER VARIABLE    x(p)  'number of patterns used';
VARIABLE            z     'cost of raw stock used';

x.up(p) = smax{i, d(i)};

EQUATION
  masterObjDef
  demand(i) 'satisfy demand';

masterObjDef.. sum{pr(p,r), c(r)*x(p)} =E= z;
demand(i)..    sum{pr(p,r), a(i,p,r)*x(p)} =G= d(i);

model master / masterObjDef, demand /;

VARIABLE rev 'revenue from new activity';
INTEGER VARIABLE act(i,r) 'number of cut widths i in knapsack r';
act.up(i,r) = floor(rs(r)/ws(i));

EQUATIONS
  revDef
  sack(r)   'knapsack constraint: widths cut fit in the raw width of r'
  ;
revDef..  sum{(i,r), u(i) *act(i,r)} =E= rev;
sack(r).. sum{i,     ws(i)*act(i,r)} =L= rs(r);

model pGen 'generate improving patterns' / revDef, sack /;

* option solprint=on;
solve master using rmip minimizing z;
abort$[master.modelStat <> 1] 'bad model status for master';

option solprint=off,optcr=0,limrow=0,limcol=0;
nIter = 0;
loop{iter$[not done],
  nIter = nIter + 1;
  solve master using rmip minimizing z;
  abort$[master.modelStat <> 1] 'bad model status for master';
  u(i) = demand.m(i);
  solve pGen using MIP max rev;
  abort$[pGen.modelStat <> 1] 'bad model status for pattern generator';
  pat(i,r) = round(act.l(i,r));
  gain(r) = sum{i, u(i)*pat(i,r)} - c(r);
  nImp = 0;
  loop {r$[gain(r) > 1e-5],
    nImp = nImp + 1;
    pp(tp) = yes;
    pr(tp,r) = yes;
    a(i,tp,r) = pat(i,r);
    tp(p) = tp(p-1);
  };
  done = [nImp eq 0];
};

solve master using mip minimizing z;

Parameter patrep Solution pattern report
          demrep Solution demand supply report;

patrep('# produced',pr(p,r)) = round(x.l(p));
patrep(i,pr(p,r))$patrep('# produced',p,r) = a(i,p,r);
patrep('# produced',r,'total') = sum{pr(p,r), patrep('# produced',p,r)};

demrep(i,'produced') = sum{pr,patrep(i,pr)*patrep('# produced',pr)};
demrep(i,'demand') = d(i);
demrep(i,'over') = demrep(i,'produced') - demrep(i,'demand');

display patrep, demrep;
execute_unload '%OUTGDX%', patrep, demrep;

file log / '' /;
putclose log  / 'Iteration count: ', nIter
              / '  # of patterns: ', card(pp);
