* cutting stock model, all patterns pre-computed
* data from
* P. C. Gilmore and R. E. Gomory, A linear programming approach to the
* cutting stock problem, Part I, Operations Research 9 (1961), 849-859.
SETS
  i    'cut/finished widths' / w1*w3 /
  r    'raw/stock widths'    / r1*r3 /
  p    'possible patterns'   / p1 * p1000 /
  pr(p,r) 'actual pattern with its raw width'
  ;
PARAMETERS
  rs(r) 'size of raw widths' /
    r1  5
    r2  6
    r3  9
  /
  c(r) 'raw costs' /
    r1  6
    r2  7
    r3 10
  /
  ws(i) 'size of cut widths' /
    w1  2
    w2  3
    w3  4
  /
  d(i) 'demand quantities for cut widths' /
    w1  20
    w2  10
    w3  20
  /
  a(i,p,r) 'count of cut widths i in pattern p from raw r';

TABLE apri(p,r,i)
*         2   3   4
         w1  w2  w3
*                     r1 length 5
p1.r1     0   0   1
p2.r1     1   1   0
p3.r1     2   0   0

*                     r2 length 6
p4.r2     1   0   1
p5.r2     0   2   0
p6.r2     1   1   0
p7.r2     3   0   0

*                     r3 length 9
p8.r3     0   0   2
p9.r3     1   1   1
p10.r3    2   0   1
p11.r3    0   3   0
p12.r3    1   2   0
p13.r3    3   1   0
p14.r3    4   0   0
;

pr(p,r) = YES$[sum{i, apri(p,r,i)} > 0];
a(i,p,r) = apri(p,r,i);

INTEGER VARIABLE    x(p)  'number of patterns used';
VARIABLE            z     'cost of raw stock used';

x.up(p) = smax{i, d(i)};

EQUATION
  objDef
  demand(i) 'satisfy demand';

objDef..     sum{pr(p,r), c(r)*x(p)} =E= z;
demand(i)..  sum{pr(p,r), a(i,p,r)*x(p)} =G= d(i);

model cutStockMIP / objDef, demand /;

option solprint=on;
solve cutStockMIP using mip minimizing z;

Parameter patrep Solution pattern report
          demrep Solution demand supply report;

patrep('# produced',pr(p,r)) = round(x.l(p));
patrep(i,pr(p,r))$patrep('# produced',p,r) = a(i,p,r);
patrep('# produced',r,'total') = sum{pr(p,r), patrep('# produced',p,r)};

demrep(i,'produced') = sum{pr,patrep(i,pr)*patrep('# produced',pr)};
demrep(i,'demand') = d(i);
demrep(i,'over') = demrep(i,'produced') - demrep(i,'demand');

display patrep, demrep;
execute_unload 'cs1Rep', patrep, demrep;

* export prices to GDX
parameter
  u(i)
  rep(i,*);
u(i) = demand.m(i);
rep(i,'price') = u(i);
rep(i,'width') = ws(i);
rep(i,'value') = u(i) / ws(i);
execute_unload 'prices', u, rep;
