$ontext
Given prices for each cut width demanded and each raw width to cut from,
find a profitable pattern for each raw width
$offtext

SETS
  i    'cut/finished widths'
  r    'raw/stock widths'
  ;
PARAMETERS
  rs(r) 'size of raw widths'
  c(r)  'raw costs'
  ws(i) 'size of cut widths'
  u(i)  'marginal prices for each cut width'
  ;
$gdxin csDataGG1
$loaddc i r rs c ws
$gdxin

$gdxin prices
$loaddc u
$gdxin

VARIABLE z;
INTEGER VARIABLE a(i,r) 'number of cut widths i in knapsack r';
a.up(i,r) = floor(rs(r)/ws(i));

EQUATIONS
  objDef
  sack(r)   'knapsack constraint: widths cut fit in the raw width of r'
  ;
objDef..  sum{(i,r), u(i) *a(i,r)} =E= z;
sack(r).. sum{i,     ws(i)*a(i,r)} =L= rs(r);

model pGen 'generate improving patterns' / all /;
pGen.optcr = 1e-5;
solve pGen using MIP max z;

parameters
  newp(i,r) 'new pattern for raw width r'
  gain(r)   'profit from activity newp'
  ;
newp(i,r) = round(a.l(i,r));
gain(r) = sum{i, u(i)*newp(i,r)} - c(r);
execute_unload 'pGen', newp, gain;
file log / '' /;
if {(smax[r, gain(r)] > 1e-4),
  putclose log 'Improving pattern(s) found';
else
  putclose log 'No improving patterns found';
};
