# given the basic data:
#   cut widths: sizes and demands
#   raw widths: sizes and costs
#   max # of possible patterns to generate
#
# generate the patterns and write them to GDX

source ("genApri.R")

p <- paste0("p",as.character(1:pMax))

idf <- as.data.frame(i)
attr(idf,'symName') <- 'i'
attr(idf,'ts') <- 'cut/finished widths'

rdf <- as.data.frame(r)
attr(rdf,'symName') <- 'r'
attr(rdf,'ts') <- 'raw/stock widths'

pdf <- as.data.frame(p)
attr(pdf,'symName') <- 'p'
attr(pdf,'ts') <- 'possible patterns'

ddf <- as.data.frame(i)
ddf$val <- wd
attr(ddf,'symName') <- 'd'
attr(ddf,'ts') <- 'demand'

wsdf <- as.data.frame(i)
wsdf$val <- ws
attr(wsdf,'symName') <- 'ws'
attr(wsdf,'ts') <- 'size of cut widths'

cdf <- as.data.frame(r)
cdf$val <- rawCost
attr(cdf,'symName') <- 'c'
attr(cdf,'ts') <- 'raw costs'

rsdf <- as.data.frame(r)
rsdf$val <- rs
attr(rsdf,'symName') <- 'rs'
attr(rsdf,'ts') <- 'size of raw widths'


auels <- list(p,r,i)
aval <- genApri(ws,rs,pMax)

alst <- list(name='apri',type='parameter',dim=3,form='sparse',
             val=aval,uels=auels)
wgdx.lst(gdxName,list(idf,rdf,pdf,ddf,wsdf,cdf,rsdf,alst))
