# read in the GAMS data:
#   the states to plot data for
#   the commodities to consider
#   the scaled production for each commodity and state
#   the scale factor w for each state

library(maps)
fnData <- "stateRes.gdx"
sdf <- rgdx.set(fnData,'s')
cdf <- rgdx.set(fnData,'c')
s <- (rgdx(fnData,list(name='sPrd',form='full')))$val
w <- (rgdx(fnData,list(name='w',form='full')))$val

slist <- as.vector(sdf$i)
ns <- length(slist)  # number of states
idx <- match(slist, state.name)
x <- state.center$x[idx]
y <- state.center$y[idx]
nc <- dim(cdf)[1]  # number of commodities: each commodity gets a color
colors <- rainbow(nc)

# define the maximum size of the chart elements
minradius <- +Inf
for (i in 1:ns) {
    for (j in 1:ns) {
    	if (i != j) {
	   r <- (x[i]-x[j])^2 + (y[i]-y[j])^2
	   minradius <- min(minradius,r)
        }
    }
}
minradius <- sqrt(minradius)

np <- 200  # define the number of polygon points on the arc
npp <- np + 1
n <- np - 1
xx <- rep(0,npp)
yy <- xx
rad0 <- max(0.4, 0.5 * minradius)  # maximum radius of pie chart

map("state", interior = FALSE,lty=2)
map("state", boundary = TRUE, add = TRUE,region=slist)
# map('state',region=slist)
# map.axes()

for (k in 1:ns) {
    xx[npp] <- x[k]
    yy[npp] <- y[k]
    xfac <- 1 / cos((y[k]*pi)/180)
    r <- rad0 * w[k]
    beta <- 0
    for (c in 1:nc) {
	alpha <- s[c,k]*2*pi
	for (i in 1:np) {
	    xx[i] <- xx[npp] + r*sin(beta + alpha *(i-1)/n)*xfac
	    yy[i] <- yy[npp] + r*cos(beta + alpha *(i-1)/n)
	}
	beta <- beta + alpha
	coord <- cbind(xx,yy)
	polygon (coord,col=colors[c])
    }
}

xpac <- -120
ypac <- 30
xfac <- 1 / cos((ypac*pi)/180)
xleg <- vector(mode='numeric',length=nc)
yleg <- vector(mode='numeric',length=nc)
cleg <- vector(mode="character",length=nc)
pleg <- vector(mode="integer",length=nc)
xx[npp] <- xpac
yy[npp] <- ypac
r <- rad0
beta <- 0
for (c in 1:nc) {
  alpha <- (2/3)*pi
  theta <- beta + alpha * 0.5
  xleg[c] <- xpac + 2.5*r*sin(theta)
  yleg[c] <- ypac + 1.6*r*cos(theta)
  cleg[c] <- paste0("commodity",as.character(c))
  cleg[c] <- as.character(cdf$i[c])
  if      (theta <= (  pi/2)) pleg[c] <- 4
  else if (theta <= (3*pi/2)) pleg[c] <- 1
  else if (theta <= (5*pi/2)) pleg[c] <- 3
  else if (theta <= (7*pi/2)) pleg[c] <- 2
  else                        pleg[c] <- 4
  for (i in 1:np) {
    xx[i] <- xx[npp] + r*sin(beta + alpha *(i-1)/n)*xfac
    yy[i] <- yy[npp] + r*cos(beta + alpha *(i-1)/n)
  }
  beta <- beta + alpha
  coord <- cbind(xx,yy)
  polygon (coord,col=colors[c])
}

text(xleg,yleg,labels=cleg,col=colors)
