$Title Combined Heat and Power Generation
$eolcom //

$if not set maxh $set maxh 672
Sets  h           Hours                    / h1*h%maxh% /
      m           Matter                   / Gas, Coal, Wasteheat, Exhaust, Steam, Heat, Electricity /
      mext(m)     External demanded Matter / Heat, Electricity /
      fuel(m)     Fuel                     / Gas, Coal /
      p           Processes                / SG  SteamGenerator
                                             HTB HighTemperatureBoiler
                                             GT  GasTurbine
                                             HRB HeatRecoveryBoiler
                                             HE  HeatExchanger
                                             ST  SteamTurbine
                                             HC  HeatCondenser /
      pmin(p)     Processes with minimum utilization level
      s           Processsegment           / 0, 1 /
      tsh         Time series header       / HeatDemand, ElectricityDemand, EXPrice /;

Parameter
      ts(h,tsh)    Time series
      dem(h,mext)  External demand in MW (heat and electricity)
      ex(h)        Energy eXchange electricity price in $ per MW
      io(m,p,s)    In- and outputprocesstable
      fp(fuel)     Fuel price in $ per MWh                                         / Gas  19.23
                                                                                     Coal 12.23 /;

Scalar
      chpbonus     Bonus for electricity generation with cogeneration in $ per MWh / 8 /;

$call gdxxrw chpin1.xls o=chpin.gdx par=io rng=Plant!a1 rdim=1 cdim=2 par=ts rng=Timeseries!a1 dim=2
$if errorlevel 1 $abort 'Problem when reading Exceldata'

$gdxin chpin
$load ts io

dem(h,'Electricity') = ts(h,'ElectricityDemand');
dem(h,'Heat')        = ts(h,'HeatDemand');
ex(h)                = ts(h,'EXPrice');
pmin(p)              = sum(m, io(m,p,'0')) <> 0;

Variable
      PL(h,p,s)        Processlevel
      F(h,m)           Fueluse in MW
      G(h,m)           Generated heat and electricity in MW
      TEX(h)           Trade of electricity at EX in MW
      ONOFF(h,p)       Indicator for running processes
      OBJ              Systemcost in $;

Positive Variables PL, F, G;
Binary Variables ONOFF;

Equations
      defobj           Objective function
      defbal(h,m)      Mass balance
      defE(h)          Electricity balance
      defH(h)          Heat balance
      defseg(h,p)      Convexcombination of segments
;

defobj..     OBJ =e=  sum((h,fuel), fp(fuel)*F(h,fuel))           // Fuelcosts
                    + sum(h,        ex(h)*TEX(h))                 // Costs/returns from electricity trading
                    - sum(h,        chpbonus*G(h,'Electricity')); // Bonus for electricity generation in cogeneration

defbal(h,m)..  0 =e= F(h,m)$fuel(m) - G(h,m)$mext(m) +
                     sum((p,s)$io(m,p,s), io(m,p,s)*PL(h,p,s));

defE(h)..      dem(h,'Electricity')  =e= G(h,'Electricity') + TEX(h);

defH(h)..      dem(h,'Heat') =e= G(h,'Heat');

defseg(h,p)..  sum(s, PL(h,p,s)) =e= 1$(not pmin(p)) + ONOFF(h,p)$pmin(p);

model chp /all/;

solve  chp min obj using mip;

parameter rep;
rep('GT ON')     = sum(h, ONOFF.l(h,'GT'));
rep('GT Starts') = sum(h, max(0,ONOFF.l(h,'GT')-ONOFF.l(h-1,'GT')));
display rep;
