$TITLE 'Christmas tree sudoku model - final with cut'

$ontext
This is a complete version of the Christmas tree sudoku model,
with initial data part of the model and a cut to
check that there is a unique solution
$offtext

set R / r1 * r9 /;
set C / c1 * c9 /;
set B / b1 * b9 /;
set V / v1 * v9 /;

set BRC(B,R,C) 'block-row-column incidence matrix' /
b1.r1.(c1*c4)
b1.r2.(c1*c4)
b1.r3.(c1)
b2.(r1*r5).c5
b2.(r3*r4).(c4,c6)
b3.r1.(c6*c9)
b3.r2.(c6*c9)
b3.r3.(c9)

b4.r3.(c2*c3)
b4.r4.c3
b4.(r4*r6).(c1*c2)
b5.r3.(c7*c8)
b5.r4.c7
b5.(r4*r6).(c8*c9)
b6.r5.(c3,c4,c6,c7)
b6.r6.(c3*c7)

b7.r7.c1
b7.(r8*r9).(c1*c4)
b8.r7.(c2*c8)
b8.(r8*r9).c5
b9.r7.c9
b9.(r8*r9).(c6*c9)
/;

display BRC;

parameter
  posCount(B) 'count positions in each block',
  check(R,C) 'count number of blocks each grid square is in';

posCount(B) = sum {BRC(B,R,C), 1} - 9;
check(R,C) = sum {BRC(B,R,C), 1} - 1;
abort$[card(check)] 'if BRC partitions the grid, check-1 should be 0!!';
abort$[card(posCount)] 'if BRC partitions the grid, posCount-9 should be 0!!';

parameter sol(R,C);

table known(R,C)
   c1 c2 c3 c4 c5 c6 c7 c8 c9
r1     3        2        9
r2        1           2
r3           7     3
r4     7     4     9     2
r5     6  2           8  3
r6           1     5
r7
r8           8     4
r9  3                       5 ;

parameter n(V);
n(V) = ord(V);

variables
  z,
  s(R,C)   'sudoku value in position R,C';

binary variables
  x(R,C,V) 'put value n(V) in position R,C';

equations
  zDef,
  sKnown(R,C)	'fix s for known positions',
  sEq(R,C),
  oneVal(R,C) 'put one value in each position',
  rPart(R,V)  'partition row into v1..v9'
  cPart(C,V)  'partition column into v1..v9'
  bPart(B,V)  'partition blocks into v1..v9'
  ;

zDef.. z =E= -s('r1','c1');
sKnown(R,C)$[known(R,C)].. s(R,C) =E= known(R,C);
sEq(R,C).. s(R,C) =E= sum {V, x(R,C,V)*n(V)};
oneVal(R,C).. sum {V, x(R,C,V)} =E= 1;
rPart(R,V)..  sum {C, x(R,C,V)} =E= 1;
cPart(C,V)..  sum {R, x(R,C,V)} =E= 1;
bPart(B,V)..  sum {BRC(B,R,C), x(R,C,V)} =E= 1;

model sudoku / all /;

x.fx(R,C,V)$[known(R,C)] = (n(V) eq known(R,C));
solve sudoku using mip minimizing z;

abort$[sudoku.modelstat > 1] 'no solution!';

sol(R,C) = s.l(R,C);
option decimals = 0;
display sol;

scalar vvv;
vvv = 0; 
vvv = sol('r5','c9');

equation bcut 'binary cut to exclude solution found above';

bcut.. sum {(R,C,V),   x(R,C,V) $[x.l(R,C,V) < 0.5] +
                    (1-x(R,C,V))$[x.l(R,C,V) > 0.5]} =G= 1;

model sudokucut / all /;
solve sudokucut using mip minimizing z;

abort$[sudokucut.modelstat eq 1] 'solution after cut!!';

file log /''/;
put log 'value = ', vvv;
