$if not set filename $set filename samuraiData.xls
$if not set i        $set i 1
$call =gdxxrw.exe %filename% output=samurai.gdx par=problem rng=input%i% dim=2
$if errorlevel 1 $abort 'Problems reading Samurai puzzle from Excel'

sets  r  rows    / r1 * r9/
      c  columns / c1 * c9/
      v  values  / v1 * v9/
      sr sub-row /sr1 * sr3/
      sc sub-col /sc1 * sc3/
      srs(sr, r) /sr1.(r1*r3), sr2.(r4*r6), sr3.(r7*r9)/
      scs(sc, c) /sc1.(c1*c3), sc2.(c4*c6), sc3.(c7*c9)/
;

sets  i total rows    / i1*i21 /
      j total columns / j1*j21 /
      p  puzzles      / nw, sw, oo, ne, se/
      o(p,sr,sc,p,sr,sc)  overlap of subsquares /
         nw.sr3.sc3.oo.sr1.sc1
         sw.sr1.sc3.oo.sr3.sc1
         ne.sr3.sc1.oo.sr1.sc3
         se.sr1.sc1.oo.sr3.sc3
      /
      oc(p,r,c,p,r,c) overlap off cells;

Parameters
  cv(sr,sc,r,c) cell value from 1 to 9
  cvalue;

loop{(sr,sc),
  cvalue=1;
  loop{(srs(sr,r),scs(sc,c)),
    cv(sr,sc,r,c) = cvalue;
    cvalue=cvalue+1; };
};

alias (p,px),(r,rx),(c,cx),(sc,scx),(sr,srx);

loop{(o(p,sr,sc,px,srx,scx),r,c,rx,cx)$[srs(sr,r) and srs(srx,rx)
                                        and scs(sc,c) and scs(scx,cx)],
  oc(p,r,c,px,rx,cx) =  [cv(sr,sc,r,c)=cv(srx,scx,rx,cx)]; };

Parameter problem(i,j) the problem;
$gdxin samurai.gdx
$load problem
display problem;

Parameters
  coffset(p)   'row offset of puzzle'    / nw 0 , sw 0 , oo 6, ne 12, se 12 /
  roffset(p)   'column offset of puzzle' / nw 0 , sw 12, oo 6, ne  0, se 12 /
  pproblem(p,r,c)  'problem for each puzzle';

* Copy the samurai into the individual puzzles
loop {(p,r,c,i,j)$(ord(i)-roffset(p)=ord(r) and ord(j)-coffset(p)=ord(c)),
  pproblem(p,r,c) = problem(i,j); };

Parameter  value(v) "Values";
value(v) = ord(v) ;

binary variable x(p,r,c,v);
variable w;
equations
  oneVal(p,r,c)      "exactly one value for each cell"
  rEq(p,r,v)         "row entries have to be unique"
  cEq(p,c,v)         "columns entries have to be unique"
  bEq(p,sr,sc,v)     "block entries have to be unique"
  nobj               "definition of objective - anything"
;

oneVal(p,r,c)..   sum(v, x(p,r,c,v)) =E= 1;
rEq(p,r,v)..      sum(c, x(p,r,c,v)) =E= 1;
cEq(p,c,v)..      sum(r, x(p,r,c,v)) =E= 1;
bEq(p,sr,sc,v)..  sum((c,r)$(scs(sc, c) and srs(sr, r)), x(p,r,c,v)) =E= 1;

nobj..      w =E= sum((p,r,c,v), x(p,r,c,v));

equation overlap(p,r,c,p,r,c,v) enforce overlap of puzzles;
overlap(oc(p,r,c,px,rx,cx),v).. x(p,r,c,v) =e= x(px,rx,cx,v);

* Fix values in the problem
x.fx(p,r,c,v)$(pproblem(p,r,c) = value(v)) = 1 ;

option limrow=0, limcol=0, mip=cplex;
model samurai /oneVal, rEq, cEq, bEq, nobj, overlap/;
solve samurai minimizing w using mip;

parameter  psolution(p,r,c)   "Display of results";
psolution(p,r,c) = pproblem(p,r,c);
loop(v, psolution(p,r,c)$(x.l(p,r,c,v) and (not pproblem(p,r,c))) = -Ord(v));
option decimals=0; display psolution;

Parameter solution(i,j)
* Copy the solution of individual puzzles into samurai
loop((p,r,c,i,j)$(ord(i)-roffset(p)=ord(r) and ord(j)-coffset(p)=ord(c)),
  solution(i,j) = psolution(p,r,c));

$if exist solution.gdx $call del solution.gdx
execute_unload "solution.gdx",solution;
execute "=gdxxrw.exe solution.gdx output=%filename% par=solution rng=output dim=2";
abort$errorlevel 'Problems writing Samurai puzzle to Excel'

equation bcut eliminate the solution;

bcut.. sum {(p,r,c,v), x(p,r,c,v) $[x.l(p,r,c,v) < 0.5] +
                    (1-x(p,r,c,v))$[x.l(p,r,c,v) > 0.5]} =G= 1;

model samuraicut / samurai, bcut /;
solve samuraicut minimizing w using mip;

$if exist solution.txt $call del solution.txt
file f /solution.txt/;
put f,
   " Solver: CPLEX"/
   " equations: ",samurai.numequ:0:0," variables: ",samurai.numvar:0:0/
   " model status: ",samurai.tmodstat/
   " solver status: ",samurai.tsolstat/
   " iterations: ",samurai.iterusd:0:0," solve time: ",samurai.resusd:0/;
put$(samuraicut.modelstat=1)  " Multiple solutions!!!" /;
abort$(samuraicut.modelstat=1) 'Multiple solutions!!!';
