sets  r  rows    / r1 * r9/
      c  columns / c1 * c9/
      v  values  / v1 * v9/
      sr sub-row /sr1 * sr3/
      sc sub-col /sc1 * sc3/
      srs(sr, r) /sr1.(r1*r3), sr2.(r4*r6), sr3.(r7*r9)/
      scs(sc, c) /sc1.(c1*c3), sc2.(c4*c6), sc3.(c7*c9)/
;

sets  i total rows    / i1*i21 /
      j total columns / j1*j21 /
      p  puzzles      / nw, sw, oo, ne, se/
      o(p,sr,sc,p,sr,sc)  overlap of subsquares /
         nw.sr3.sc3.oo.sr1.sc1
         sw.sr1.sc3.oo.sr3.sc1
         ne.sr3.sc1.oo.sr1.sc3
         se.sr1.sc1.oo.sr3.sc3
      /
      oc(p,r,c,p,r,c) overlap off cells;

Parameters
  cv(sr,sc,r,c) cell value from 1 to 9
  cvalue;

loop{(sr,sc),
  cvalue=1;
  loop{(srs(sr,r),scs(sc,c)),
    cv(sr,sc,r,c) = cvalue;
    cvalue=cvalue+1; };
};

alias (p,px),(r,rx),(c,cx),(sc,scx),(sr,srx);

loop{(o(p,sr,sc,px,srx,scx),r,c,rx,cx)$[srs(sr,r) and srs(srx,rx)
                                        and scs(sc,c) and scs(scx,cx)],
  oc(p,r,c,px,rx,cx) =  [cv(sr,sc,r,c)=cv(srx,scx,rx,cx)]; };

Table problem(i,j) the problem
    j1 j2 j3 j4 j5 j6 j7 j8 j9 j10 j11 j12 j13 j14 j15 j16 j17 j18 j19 j20 j21

i1      8                 6                      2                       3
i2   4  7                 5  1               3   7                       8   9
i3         5  8     1  9                             5   7       3   1
i4         9     5     6                             9       5       4
i5            1     6                                    8       9
i6         3     7     2                             4       7       3
i7         4  5     3  1                             2   4       7   6
i8   5  3                 2  4               1   3                       7   4
i9      6                 3          2           4                       2
i10                              4       6
i11                          3               8
i12                              3       8
i13     5                 7          1           8                       1
i14  2  4                 9  1               7   2                       9   8
i15        9  8     2  6                             9   7       6   2
i16        2     4     9                             3       2       4
i17           2     7                                    6       3
i18        1     3     2                             7       1       5
i19        8  5     3  4                             2   4       9   1
i20  6  1                 5  8               1   7                       4   5
i21     2                 3                      4                       2
;

Parameters
  coffset(p)   'row offset of puzzle'    / nw 0 , sw 0 , oo 6, ne 12, se 12 /
  roffset(p)   'column offset of puzzle' / nw 0 , sw 12, oo 6, ne  0, se 12 /
  pproblem(p,r,c)  'problem for each puzzle';

* Copy the samurai into the individual puzzles
loop {(p,r,c,i,j)$(ord(i)-roffset(p)=ord(r) and ord(j)-coffset(p)=ord(c)),
  pproblem(p,r,c) = problem(i,j); };


Parameter  value(v) "Values";
value(v) = ord(v) ;

binary variable x(p,r,c,v);
variable w;
equations
  oneVal(p,r,c)      "exactly one value for each cell"
  rEq(p,r,v)         "row entries have to be unique"
  cEq(p,c,v)         "columns entries have to be unique"
  bEq(p,sr,sc,v)     "block entries have to be unique"
  nobj               "definition of objective - anything"
  ;

oneVal(p,r,c)..   sum(v, x(p,r,c,v)) =E= 1;
rEq(p,r,v)..      sum(c, x(p,r,c,v)) =E= 1;
cEq(p,c,v)..      sum(r, x(p,r,c,v)) =E= 1;
bEq(p,sr,sc,v)..  sum((c,r)$(scs(sc, c) and srs(sr, r)), x(p,r,c,v)) =E= 1;

nobj..      w =E= sum((p,r,c,v), x(p,r,c,v));

equation overlap(p,r,c,p,r,c,v)   'enforce overlap of puzzles';
overlap(oc(p,r,c,px,rx,cx),v)..  x(p,r,c,v) =e= x(px,rx,cx,v);

* Fix values in the problem
x.fx(p,r,c,v)$[pproblem(p,r,c) = value(v)] = 1 ;

option limrow=0, limcol=0, mip=cplex;
model samurai /oneVal, rEq, cEq, bEq, nobj, overlap/;
solve samurai minimizing w using mip;

parameter  psolution(p,r,c)   "Display of results";
psolution(p,r,c) = pproblem(p,r,c);
loop(v, psolution(p,r,c)$(x.l(p,r,c,v) and (not pproblem(p,r,c))) = Ord(v));
option decimals=0; display psolution;

Parameter solution(i,j)
* Copy the solution of individual puzzles into samurai
loop{(p,r,c,i,j)$(ord(i)-roffset(p)=ord(r) and ord(j)-coffset(p)=ord(c)),
  solution(i,j) = psolution(p,r,c)
};

option decimals=0; display solution;

equation bcut eliminate the solution;

bcut.. sum {(p,r,c,v), x(p,r,c,v) $[x.l(p,r,c,v) < 0.5] +
                    (1-x(p,r,c,v))$[x.l(p,r,c,v) > 0.5]} =G= 1;

model samuraicut / samurai, bcut /;
solve samuraicut minimizing w using mip;

abort$(samuraicut.modelstat=1) 'Multiple solutions!!!';
