$TITLE 'Basic sudoku model - final with cut'

$ontext
This is a complete version of the basic sudoku model,
with initial data read from test.txt and a cut to
check that there is a unique solution
$offtext

set R / r1 * r9 /;
set C / c1 * c9 /;
set B / b1 * b9 /;
set V / v1 * v9 /;

* the 9x9 grid is indexed by rows R, columns C
* B is the set of blocks that also need to be partitioned 1..9:
*  B =    1  2  3
*         4  5  6
*         7  8  9
* Note that we partition the 9x9 grid into blocks in a generic way:
* we may be solving a Christmas-tree sudoku

set BR(B,R) /
  (b1*b3).(r1*r3),
  (b4*b6).(r4*r6),
  (b7*b9).(r7*r9)
 /;
set BC(B,C) /
  (b1,b4,b7).(c1*c3),
  (b2,b5,b8).(c4*c6),
  (b3,b6,b9).(c7*c9)
 /;
           
set BRC(B,R,C) 'block-row-column incidence matrix';
BRC(B,R,C) = BR(B,R) and BC(B,C);
display BRC;

parameter
  posCount(B) 'count positions in each block',
  check(R,C) 'count number of blocks each grid square is in';

posCount(B) = sum {BRC(B,R,C), 1} - 9;
check(R,C) = sum {BRC(B,R,C), 1} - 1;
abort$[card(check)] 'if BRC partitions the grid, check-1 should be 0!!';
abort$[card(posCount)] 'if BRC partitions the grid, posCount-9 should be 0!!';

parameter sol(R,C);

table known(R,C)
$include test.txt
;

parameter n(V);
n(V) = ord(V);

variables
  z,
  s(R,C)   'sudoku value in position R,C';

binary variables
  x(R,C,V) 'put value n(V) in position R,C';

equations
  zDef,
  sKnown(R,C)	'fix s for known positions',
  sEq(R,C),
  oneVal(R,C) 'put one value in each position',
  rPart(R,V)  'partition row into v1..v9'
  cPart(C,V)  'partition column into v1..v9'
  bPart(B,V)  'partition blocks into v1..v9'
  ;

zDef.. z =E= -s('r1','c1');
sKnown(R,C)$[known(R,C)].. s(R,C) =E= known(R,C);
sEq(R,C).. s(R,C) =E= sum {V, x(R,C,V)*n(V)};
oneVal(R,C).. sum {V, x(R,C,V)} =E= 1;
rPart(R,V)..  sum {C, x(R,C,V)} =E= 1;
cPart(C,V)..  sum {R, x(R,C,V)} =E= 1;
bPart(B,V)..  sum {BRC(B,R,C), x(R,C,V)} =E= 1;

model sudoku / all /;

x.fx(R,C,V)$[known(R,C)] = (n(V) eq known(R,C));
solve sudoku using mip minimizing z;

abort$[sudoku.modelstat > 1] 'no solution!';

sol(R,C) = s.l(R,C);
option decimals = 0;
display sol;

scalar vvv;
vvv = 0; 
vvv = sol('r5','c9');

equation bcut 'binary cut to exclude solution found above';

bcut.. sum {(R,C,V),   x(R,C,V) $[x.l(R,C,V) < 0.5] +
                    (1-x(R,C,V))$[x.l(R,C,V) > 0.5]} =G= 1;

model sudokucut / all /;
solve sudokucut using mip minimizing z;

abort$[sudokucut.modelstat eq 1] 'solution after cut!!';

file log /''/;
put log 'cheater value = ', vvv;
