$TITLE 'Basic sudoku model - incomplete'

$ontext
This is an incomplete version of the basic sudoku model, lacking: 
  - Some data checks
  - computation of BRC
  - some equation definitions
  - re-solve with first solution cut off
$offtext

set R / r1 * r9 /;
set C / c1 * c9 /;
set B / b1 * b9 /;
set V / v1 * v9 /;

* the 9x9 grid is indexed by rows R, columns C
* B is the set of blocks that also need to be partitioned 1..9:
*  B =    1  2  3
*         4  5  6
*         7  8  9
* Note that we partition the 9x9 grid into blocks in a generic way:
* we may be solving a Christmas-tree sudoku

set BR(B,R) /
  (b1*b3).(r1*r3),
  (b4*b6).(r4*r6),
  (b7*b9).(r7*r9)
 /;
set BC(B,C) /
  (b1,b4,b7).(c1*c3),
  (b2,b5,b7).(c4*c6),
  (b3,b6,b9).(c7*c9)
 /;
           
set BRC(B,R,C) 'block-row-column incidence matrix';
* this needs work!
BRC(B,R,C) = no;
display BRC;

parameter sol(R,C);

table known(R,C)
   c1 c2 c3   c4 c5 c6   c7 c8 c9
r1             2     6          1
r2  4                9       8
r3  5

r4     4  6    9  2
r5        1    4     8    7
r6                3  5    6  4

r7                              7
r8     2       7                8
r9  9          8     3            ;


parameter n(V);
n(V) = ord(V);

variables
  z,
  s(R,C)   'sudoku value in position R,C';

binary variables
  x(R,C,V) 'put value n(V) in position R,C';

equations
  zDef,
  sKnown(R,C)	'fix s for known positions',
  sEq(R,C),
  oneVal(R,C) 'put one value in each position',
  rPart(R,V)  'partition row into v1..v9'
  cPart(C,V)  'partition column into v1..v9'
  bPart(B,V)  'partition blocks into v1..v9'
  ;

zDef.. z =E= -s('r1','c1');
sKnown(R,C)$[known(R,C)].. s(R,C) =E= known(R,C);
sEq(R,C).. s(R,C) =E= sum {V, x(R,C,V)*n(V)};
oneVal(R,C).. 
rPart(R,V)..  
cPart(C,V)..  
bPart(B,V)..  

model sudoku / all /;

x.fx(R,C,V)$[known(R,C)] = (n(V) eq known(R,C));
solve sudoku using mip minimizing z;

abort$[sudoku.modelstat > 1] 'no solution!';

sol(R,C) = s.l(R,C);
option decimals = 0;
display sol;

scalar vvv;
vvv = 0; 
vvv = sol('r5','c9');

file log /''/;
put log 'cheater value = ', vvv;
