
$funclibin stolib stodclib

function cdfnorm     /stolib.cdfnormal    /
         icdfnorm    /stolib.icdfnormal   /;
function pdfnorm     /stolib.pdfnormal    /;
function cdfbin      /stolib.cdfbinomial  /;
function icdfbin      /stolib.icdfbinomial /;
function pdfbin      /stolib.pdfbinomial  /;

function cdflognorm  /stolib.cdflognormal     /;

set i /i1*i20/
set j /xval,cdf,pdf/
parameter normalx(i,j)    normal distribution;
parameter lognormalx(i,j) log normal distribution;
normalx(i,"xval")=0.0+0.5*ord(i);
lognormalx(i,"xval")=0.0+0.5*ord(i);

normalx(i,"cdf")=cdfnorm(normalx(i,"xval"),5,2);
option decimals=8;



display normalx;

scalar lognorm_m , lognorm_s;
lognorm_m=1.6;
lognorm_s=.2;
scalar lognorm_mean,lognorm_std;

lognorm_mean=exp(lognorm_m+lognorm_s**2/2);
lognorm_std=exp(lognorm_s**2+2*lognorm_m )*(exp(lognorm_s**2)-1);
display lognorm_mean,lognorm_std;

lognormalx(i,"cdf")=cdflognorm(lognormalx(i,"xval"),lognorm_m,lognorm_s);
option decimals=8;

display lognormalx;

parameter costtostock /20/
parameter shortfallcost /40/;
parameter meandemand    /10/
parameter stddevdemand  /2/


set k /k1*k200/;
parameter del(k);
del(k)=.1+0.05*ord(k);

variable totalcost;
positive variable inventory;
equation totcost;
totcost.. totalcost=e=costtostock*inventory
        +shortfallcost*sum(k,(inventory+del(k)-inventory)*(pdfnorm((inventory+del(k)),meandemand,stddevdemand)));

model invmin /all/;
inventory.lo=meandemand;
solve invmin using dnlp minimizing totalcost;

parameter n /20/, p /0.5/;
*the next few dont work since discrete distributions cannot be in model .. commands
$ontext
equation totcost2;
totcost2.. totalcost=e=costtostock*inventory
        +shortfallcost*sum(k,(inventory+del(k)-inventory)*(pdfbin((inventory+del(k)),n,p)));
model invmin2 /totcost2/;
inventory.lo=meandemand;
solve invmin2 using dnlp minimizing totalcost;
$offtext

scalar x;

x=cdfnorm(inventory.l,meandemand,stddevdemand);
display x,inventory.l;

normalx(i,"xval")=10.0+1*ord(i);

normalx(i,"cdf")=cdfnorm(normalx(i,"xval"),10,2);
option decimals=8;



display normalx;
parameter xvals(i,*);
xvals(i,"prob")=min(ord(i)/card(i),0.99999999);
xvals(i,"val")=icdfnorm(xvals(i,"prob"),meandemand,stddevdemand);
display xvals;


parameter mean,xmedian,shouldbepoint5;
function cdfbeta     /stolib.cdfbeta    /
         icdfbeta    /stolib.icdfbeta   /;
parameter alpha /1/ ,beta /2/;
mean = alpha/(alpha+beta);
xmedian=icdfbeta(0.5,alpha,beta);
shouldbepoint5=cdfbeta(xmedian,alpha,beta);
display mean,xmedian,shouldbepoint5;

mean = alpha/(alpha+beta);
xmedian=icdfbeta(0.5,alpha,beta);
shouldbepoint5=cdfbeta(xmedian,alpha,beta);
display 'beta',mean,xmedian,shouldbepoint5;

mean=n*p;
xmedian=icdfbin(0.5,n,p);
x=cdfbin(xmedian,n,p);
display 'binary',mean,xmedian,shouldbepoint5;

function cdfcauchy     /stolib.cdfcauchy    /
         icdfcauchy    /stolib.icdfcauchy   /;
parameter median /20/, halfwidth /0.5/;
xmedian=icdfcauchy(0.5,median,halfwidth);
x=cdfcauchy(xmedian,median,halfwidth);
display 'cauchy',xmedian,shouldbepoint5;
