
$funclibin stolib stodclib

function randnorm     /stolib.dnormal    /
         randbin      /stolib.dbinomial  /
         randcauchy   /stolib.dcauchy    /
         randlognorm  /stolib.dlognormal /
         setseedh     /stolib.SetSeed    /
;
scalar x;
x=setseedh(99883);

set i /i1*i20/
set j /normal,binomial,cauchy,lognormal/
parameter randx(i,j)    numbers from distributions;

randx(i,"normal")=randnorm(5,2);
randx(i,"binomial")=randbin(10,0.5);
randx(i,"cauchy")=randcauchy(5,1);
randx(i,"lognormal")=randlognorm(1.2,0.3);

display randx;



$funclibin lsalib lsadclib
function normalSample    /lsalib.SampleLSnormal /
         lognormalSample /lsalib.SampleLSlognormal /
         cauchySample    /lsalib.SampleLScauchy /
         binomialSample  /lsalib.SampleLSbinomial /

         getSampleVal    /lsalib.getSampleValues /
         setCor          /lsalib.setCorrelation /
         indCor          /lsalib.induceCorrelation /;

scalar d,h,k,k1,k2;
set is /value01*value12/;
parameter sv(is,j);
k = normalSample(5,2,12);
loop(is, sv(is,"normal") = getSampleVal(k); );
h = lognormalSample(1.2,0.3,12);
loop(is, sv(is,"lognormal") = getSampleVal(h););
k1 = binomialSample(10,0.5,12);
loop(is, sv(is,"binomial") = getSampleVal(k1););
k2 = cauchySample(5,1,12);
loop(is, sv(is,"binomial") = getSampleVal(k2););

parameter sv2(is,*,j)       ;
sv2(is,"beforecorr","normal")=sv(is,"normal");
sv2(is,"beforecorr","lognormal")=sv(is,"lognormal");
d=setCor(h,k,-1);
d=indCor(1);
loop(is,
sv2(is,"aftercorr","normal") = getSampleVal(k);
);
display sv2;
loop(is,
sv2(is,"aftercorr","lognormal") = getSampleVal(h);
);
option sv2:2:1:2;
display sv2;
