$Title Egypt Agricultural Model  (EGYPT,SEQ=75)
$Stitle Set Definition

*   $$SETGLOBAL ADDART
$Ontext

   This model was used to analyze the current and future demands
   for irrigation water and to formulate investment programs
   in the water sector of Egypt.


Kutcher, steps P, The Agro-Economic Model, Master Plan for Water
Resources Development. Tech. rep., UNDP-EGY-73/024, 1980.

$Offtext

  Set crop crops   / lo-berseem, sh-berseem,  wheat,       barley,
                  horse-bean, lentils,     ot-legumes,  flax,
                  w-onion,    w-tomato,    w-veget,     cotton,
                  rice,       s-maize,     sorghum,     soyabeans,
                  groundnut,  sesame,      s-potato,    s-tomato,
                  s-veget,    n-maize,     n-potato,    n-tomato,
                  n-veget,    citrus,      sugarcane,   veg-oil,
                  maize  ,    s+n-tomato,  potato  /


 Set month  time periods /oct,nov,dec,jan,feb,mar,apr,may,jun,jul,aug,sep/
     region  regions by barrages  / u-egypt,   m-egypt,  e-delta, m-delta,
                                   w-delta/
     zone  agricultural zones  /  upper,  middle,  delta /

     aginput  agricultural inputs /  protein,  starch,   seed,   misc,
                                     pest,     n-fer,    p-fer        /

     mapzonetoregion(zone,region) map from zones to regions
                                   / upper.u-egypt,
                                     middle.m-egypt,
                                     delta.(e-delta,m-delta,w-delta) /

      season  agricultural seasons / winter, summer, nili /


 sv(season,crop) vegetables by season / winter.(w-veget, w-tomato, w-onion),
                                summer.(s-veget, s-tomato, s-potato),
                                nili.  (n-veget, n-tomato, n-potato) /


   Crop_Sold(crop)   crops sold in national market

   regdataparam      regional data / area, farmers, starch, protein/

   AnimalNutrients(regdataparam) nutrients for livestock  /       protein,    starch   /
   FodderCrop(crop)  fodder crops
   TransportableFodder(crop)  fodder crops transportable  /     wheat,      barley /
   GreenFodder(crop) green fodder crops /lo-berseem,   sh-berseem, sugarcane,
                              s-maize,      n-maize,    sorghum /

   DryFodder(crop) dry fodder crops   /wheat, barley, rice /

$Stitle national demand data


 Table DemandData(crop,*) demand data

                  import-p   base-p  export-p domes-cons  elas
*                  (l.e.)    (l.e.)   (l.e.)  (1000 ton)

    wheat           96.8        88      88      7634      -0.55
    barley          94.6        86      86       114      -0.20
    horse-bean     267.3       199     243       254      -0.63
    lentils        419.1       381     381        65      -0.80
    ot-legumes     267.3       240     243        55      -0.63
    w-tomato       126.5        87     115      1006      -0.75
    cotton         419.1       300     380       530      -1.00
    maize          143.0       123     130      3231      -0.68
    s+n-tomato      82.5        60      75      1636      -0.75
    w-veget        143.0       100     130      1055      -0.75
    sorghum        126.5       119     115       643      -0.64
    sugarcane       18.7        15      16     11121      -0.57
    w-onion         71.5        62      65       568      -0.64
    flax            33.0        30      30       171      -1.00
    rice           121.0        81     110      2382      -0.74
    groundnut      518.1       280     471        25      -1.00
    sesame         704.0       600     640        97      -1.00
    soyabeans      432.3       210     393       110      -1.00
    potato          94.6        80      85      1230      -0.77
    s-veget         71.5        65      65      2333      -0.75
    n-veget         77.0        70      70       730      -0.77
    citrus          93.5        85      85      1102      -1.64
    veg-oil        500.5       455     455       395      -1.20
    ;
   Crop_Sold(crop) = yes$DemandData(crop,"domes-cons") ;


$Stitle regional data


 Table RegionalData (region,regdataparam) agricultural regions data

                  area     farmers    starch      protein
*               (1000 f)  (1000"season)   (1000 ton)   (1000 ton)
        u-egypt  1195      1202         987         176
        m-egypt  1009       986        1057         202
        e-delta  1334      1156        1720         360
        m-delta  1436      1110        1739         351
        w-delta   746       541         949         197 ;
*mccarl screws up land and increases starch need here
RegionalData("e-delta","area")=RegionalData("e-delta","area")/10;
RegionalData("e-delta","starch")=RegionalData("e-delta","starch")*1000;

 Table RegionWaterAvail(region,month) available water for each region (m m3 per month)
                       oct     nov     dec     jan     feb     mar
        u-egypt       1084    1114     930     383     789     841
        m-egypt        630     617     573     188     560     703
        e-delta        864     939     719     418     931     979
        m-delta        853     944     718     383     899     946
        w-delta        767     732     538     172     637     766

 +                     apr     may     jun     jul     aug     sep
        u-egypt        961    1074    1197    1301    1373    1181
        m-egypt        660     720     798     958     922     683
        e-delta       1023    1083    1480    1708    1597    1134
        m-delta        926    1041    1428    1713    1552    1085
        w-delta        752    858     1129    1213    1125     858

 Table RegionWageMen(region,month) average wages for men  (egyptian pounds per day )
                       oct     nov     dec     jan     feb     mar
        u-egypt        1.4     1.4     1.3     1.3     1.3     1.5
        m-egypt        1.3     1.3     1.3     1.3     1.3     1.3
        e-delta        1.3     1.3     1.3     1.0     1.2     1.2
        m-delta        1.3     1.3     1.3     1.0     1.0     1.0
        w-delta        1.3     1.3     1.2     1.0     1.0     1.2

 +                     apr     may     jun     jul     aug     sep
        u-egypt        1.5     1.5     1.5     1.5     1.5     1.5
        m-egypt        1.3     1.3     1.3     1.3     1.5     1.5
        e-delta        1.2     1.4     1.8     1.5     1.5     1.5
        m-delta        1.0     1.3     1.5     1.5     1.5     1.5
        w-delta        1.2     1.5     1.5     1.5     1.5     1.5


$Stitle  crop data


 Table Cropyield (crop,region)  Cropyield for different commodities
                 u-egypt   m-egypt    e-delta    m-delta     w-delta
*                  ton      ton        ton        ton         ton
   wheat          1.29     1.36       1.39       1.404       1.36
   barley         1.41     1.26       1.33        .984        .96
   horse-bean     1.12      .80        .96        .97         .91
   lentils         .46
   ot-legumes      .71      .73        .61        .50
   flax                               3.14       2.45        2.29
   w-onion       11.19     8.85                  9.20
   w-tomato                4.66       5.31       5.15
   w-veget        5.48     6.42       6.83       6.83        6.83
   cotton         1.13     1.00       1.18       1.13        1.18
   rice                               2.37       2.34        2.49
   s-maize        2.00     1.89       1.79       1.97        1.69
   sorghum        1.67     1.49
   soyabeans       .89      .95       1.04       1.18        1.29
   groundnut       .89                 .78
   sesame          .48
   s-potato                7.15                  7.15        7.15
   s-tomato       7.21     7.51       9.40       9.60        8.15
   s-veget        7.06     9.0        8.46       8.46        8.46
   n-maize        1.28     1.33       1.51       1.56        1.35
   n-potato       9.43     7.34       7.19       7.46        6.70
   n-tomato       7.44     7.30       8.28       6.78        8.20
   n-veget        6.60     6.83       7.16       7.16        7.16
   citrus         7.93     7.93       9.50       6.73
   sugarcane     39.22

 Table IndusByproduct(crop,region) industrial by product Cropyield (tons per feddan)

                 u-egypt   m-egypt    e-delta    m-delta     w-delta
   horse-bean     1.29      1.15       1.05        1.05       1.05
   rice                                1.25        1.25       1.25


 Table FeedYieldFromCrop(crop,zone) by product Cropyield for animal FeedYieldFromCrop (tons per feddan)

                 upper      middle       delta

 lo-berseem     27.300      25.700      22.500
 sh-berseem     12.500      10.600       9.000
 wheat           1.890       2.110       2.160
 barley          1.370       1.490       1.400
 lentils         0.650
 cotton          1.600       1.400       1.700
 rice                                    1.250
 s-maize         1.950       2.190       2.010
 sorghum         2.400       2.600
 soyabeans       0.750       0.850       1.000
 n-maize         1.370       1.400       1.600
 sugarcane       8.000
        ;
  FodderCrop(crop) = yes$sum(zone, FeedYieldFromCrop(crop,zone) );

 Table CropData (crop,*)  seed protein starch misc costs and pestic data

             protein  starch   seed    misc    pest    n-fer    p-fer
*               %       %       ton     le      le      ton      ton

   lo-berseem   2.0     9.0    .020     5.0     8.0    0.000    0.015
   sh-berseem   2.0     9.0    .020     5.0            0.000    0.015
   wheat         .1    23.3    .075    12.0            0.054    0.015
   barley        .1    23.3    .060     8.0            0.045    0.015
   horse-bean                  .078     8.0     8.0    0.007    0.022
   lentils      2.1    24.0    .080     5.0            0.007    0.015
   ot-legumes   3.1    43.2    .053     3.0            0.007    0.015
   flax                        .080     8.0            0.046    0.015
   w-onion                     .060     5.5    37.0    0.062    0.015
   w-tomato                    .020    25.0    60.0    0.090    0.023
   w-veget                     .050    25.0    10.0    0.047    0.023
   cotton      37.3    46.0    .060    20.0    44.0    0.050    0.015
   rice         9.6    70.0    .060    12.0    16.0    0.046    0.015
   s-maize      2.1     8.5    .023     8.0     6.0    0.062    0.015
   sorghum      2.1     8.5    .035     8.0     4.0    0.060    0.015
   soyabeans   40.5    69.5    .040    10.0    10.0             0.015
   groundnut     .3     5.9    .050     5.0     2.0             0.015
   sesame                      .005     8.0     3.0    0.060    0.015
   s-potato                    .750    15.0    55.0    0.008    0.022
   s-tomato                    .003    25.0    65.0    0.090    0.022
   s-veget                     .002    25.0    60.0    0.062    0.022
   n-maize      2.1     8.5    .023     8.0     4.5    0.062    0.015
   n-potato                   1.750    15.0    55.0    0.065    0.022
   n-tomato                    .003    25.0    70.0    0.093    0.022
   n-veget                     .003    20.0    60.0    0.047    0.023
   citrus                              25.0    80.0    0.300    0.100
   sugarcane     .6    11.8   6.000    10.0     3.0    0.093    0.015 ;


$Eject

 Table  LandUse(crop,zone,month) land requirements by crops

                         oct     nov    dec    jan      feb     mar

  lo-berseem.upper        .5     1       1       1       1       1
  lo-berseem.middle       .6     1       1       1       1       1
  lo-berseem.delta        .6     1       1       1       1       1
  sh-berseem.upper        .5     1       1       1       1       1
  sh-berseem.middle       .6     1       1       1       1
  sh-berseem.delta        .6     1       1       1       1
  wheat.upper             .3     1       1       1       1       1
  wheat.middle            .2     1       1       1       1       1
  wheat.delta                     .8     1       1       1       1
  barley.upper                    .6     1       1       1       1
  barley.middle                   .2     1       1       1       1
  barley.delta                    .6     1       1       1       1
  horse-bean.upper        .2     1       1       1       1       1
  horse-bean.middle       .1      .8     1       1       1       1
  horse-bean.delta                .8     1       1       1       1
  lentils.upper                  1       1       1       1        .3
  ot-legumes.upper                .5     1       1       1       1
  ot-legumes.middle               .5     1       1       1       1
  ot-legumes.delta                .5     1       1       1       1
  flax.delta                      .4     1       1       1       1
  w-onion.upper                           .6     1       1       1
  w-onion.middle                          .5     1       1       1
  w-onion.delta                           .7     1       1       1
  w-tomato.middle        1       1       1       1        .5
  w-tomato.delta         1       1       1       1        .5
  w-veget.upper          1       1       1       1       1
  w-veget.middle         1       1       1       1       1
  w-veget.delta          1       1       1       1       1
  cotton.upper                                                   1
  cotton.middle                                                  1
  cotton.delta                                                   1
  rice.delta              .5
  s-potato.middle                                         .4     1
  s-potato.delta                                          .7     1
  s-tomato.upper                                          .4     1
  s-tomato.middle                                         .6     1
  s-tomato.delta                                          .3     1
  s-veget.upper                                          1       1
  s-veget.middle                                         1       1
  s-veget.delta                                          1       1
  n-maize.upper          1       1
  n-maize.middle         1       1
  n-maize.delta          1       1
  n-potato.upper         1       1
  n-potato.middle        1       1
  n-potato.delta         1       1
  n-tomato.upper         1       1
  n-tomato.middle        1       1
  n-tomato.delta         1       1
  n-veget.upper          1
  n-veget.middle         1
  n-veget.delta          1
  citrus.upper           1       1       1       1       1       1
  citrus.middle          1       1       1       1       1       1
  citrus.delta           1       1       1       1       1       1
  sugarcane.upper        1       1       1       1       1       1

              +         apr      may    jun     jul     aug     sep

  lo-berseem.upper       1       1
  lo-berseem.middle      1       1
  lo-berseem.delta       1        .7
  wheat.upper            1
  wheat.middle           1        .2
  wheat.delta            1        .6
  barley.upper            .5
  barley.middle          1        .4
  barley.delta           1        .4
  horse-bean.upper        .3
  horse-bean.middle       .5
  horse-bean.delta        .5
  ot-legumes.upper        .5
  ot-legumes.middle       .5
  flax.delta              .4
  w-onion.upper          1
  w-onion.middle         1
  w-onion.delta          1
  cotton.upper           1       1       1       1       1       1
  cotton.middle          1       1       1       1       1       1
  cotton.delta           1       1       1       1       1       1
  rice.delta                     1       1       1       1       1
  s-maize.upper                   .5     1       1       1       1
  s-maize.middle                  .6     1       1       1       1
  s-maize.delta                   .6     1       1       1       1
  sorghum.upper                   .3     1       1       1       1
  sorghum.middle                  .3     1       1       1       1
  soyabeans.upper         .5     1       1       1        .5
  soyabeans.middle        .4     1       1       1        .5
  soyabeans.delta         .4     1       1       1        .7
  groundnut.upper         .5     1       1       1        .5
  groundnut.middle        .4     1       1       1        .7
  groundnut.delta         .5     1       1       1        .6
  sesame.upper                   1       1       1       1        .6
  s-potato.middle        1       1       1        .5
  s-potato.delta         1       1       1        .3
  s-tomato.upper         1       1       1        .6
  s-tomato.middle        1       1       1        .5
  s-tomato.delta         1       1       1        .4
  s-veget.upper          1       1       1
  s-veget.middle         1       1       1
  s-veget.delta          1       1       1
  n-maize.upper                                   .5     1       1
  n-maize.middle                                  .8     1       1
  n-maize.delta                                   .6     1       1
  n-potato.upper                                         1       1
  n-potato.middle                                        1       1
  n-potato.delta                                         1       1
  n-tomato.upper                                 1       1       1
  n-tomato.middle                                1       1       1
  n-tomato.delta                                 1       1       1
  n-veget.upper                                  1       1       1
  n-veget.middle                                 1       1       1
  n-veget.delta                                  1       1       1
  citrus.upper           1       1       1       1       1       1
  citrus.middle          1       1       1       1       1       1
  citrus.delta           1       1       1       1       1       1
  sugarcane.upper        1       1       1       1       1       1


 Table  LaborRequire(crop,zone,month) labor requirements by crops (man-days)

                         oct     nov     dec     jan     feb     mar

  lo-berseem.upper       1.5     2.5     2.5      .5     3.5     3.5
  lo-berseem.middle      1.5     3       3.5      .5     3.5     3.5
  lo-berseem.delta       2.6     3.4     3.5      .5     3.5     5.5
  sh-berseem.upper       1.5     1.5     4.5      .5     4.5     2
  sh-berseem.middle      3       2       2.5      .5     3       2
  sh-berseem.delta       1.5     1       4.5      .5     3       2
  wheat.upper            2       5.5     2.5      .5      .5      .5
  wheat.middle           1       3       1.5      .5     1.5     1.5
  wheat.delta                    4.5     1.5      .5      .5     1.5
  barley.upper                   5       1.5      .5      .5      .5
  barley.middle                  1.5     3        .5      .5      .5
  barley.delta                   3.7     3.3      .5      .5      .5
  horse-bean.upper       1.8     6.7     3.5             1       1
  horse-bean.middle      1.2     8.8     4        .5      .5      .5
  horse-bean.delta               3.2     3.8     1.5      .5      .5
  lentils.upper                  9        .5      .5     9       7
  ot-legumes.upper               9.5     9.5     5.5     5.5      .5
  ot-legumes.middle              9.5     9.5     6.5     4.5      .5
  ot-legumes.delta               9.5     9.5     5.5     4       1.5
  flax.delta                     2.6     3.5     1        .5      .5
  w-onion.upper                         13      12.5     5       1
  w-onion.middle                         7.5    13.5     6       1
  w-onion.delta                          7.5     7       3       1
  w-tomato.middle        7.5     1.5     6       7       9.5     5
  w-tomato.delta         16      5       6.5     3.5    10.5    10
  w-veget.upper          7       7       3       3       3       4
  w-veget.middle         7       7       3       3       3       5
  w-veget.delta         10       6       2       4       3       6
  cotton.upper           5                                       8
  cotton.middle          4                                       8
  cotton.delta           6                                       5
  rice.delta             9.5     4.1
  s-maize.upper          7
  s-maize.middle         5
  s-maize.delta          6
  sorghum.upper          6
  sorghum.middle         7
  s-potato.middle                                        5       8.5
  s-potato.delta                                        11       4
  s-tomato.upper                                        12       5
  s-tomato.middle                                       14.5     7
  s-tomato.delta                                         6       9
  s-veget.upper                                         12       14
  s-veget.middle                                        11       15
  s-veget.delta                                         12       15
  n-maize.upper           .5     3
  n-maize.middle         8       9.5
  n-maize.delta          4.5     4.5
  n-potato.upper         6       1.5     8.5
  n-potato.middle        7        .5     8.5
  n-potato.delta         2       8       8
  n-tomato.upper         5       3
  n-tomato.middle        8       5
  n-tomato.delta         8.5     5.5
  n-veget.upper         10       3
  n-veget.middle        10       4
  n-veget.delta          9       4
  citrus.upper           2       2       9      20       1.5     1.5
  citrus.middle          2       3       8      19       1.5     2.5
  citrus.delta           2       3      10      18       2.5     1.5
  sugarcane.upper        1      13      13      13      13

              +         apr      may    jun     jul     aug     sep

  lo-berseem.upper       5.5     2
  lo-berseem.middle      4.5     2.5
  lo-berseem.delta       5.5     2.5
  wheat.upper             .5    12
  wheat.middle           1.5    16
  wheat.delta            1.5    12
  barley.upper          10       4
  barley.middle          2.5    12.5
  barley.delta           1.5    12.5
  horse-bean.upper      11       3
  horse-bean.middle      7       6
  horse-bean.delta       7       7
  ot-legumes.upper       3.3     3.3
  ot-legumes.middle      4       2.5
  flax.delta             8      10
  w-onion.upper         18       5.5
  w-onion.middle         6
  w-onion.delta          1       8
  cotton.upper           7       5       6       2       2       1
  cotton.middle         12.5     8       8       2       2       1
  cotton.delta           5.5     4       5       1.5     1.5     1
  rice.delta                     6.2     1.8      .5     1       1
  s-maize.upper                  4.5    11       7       2       6
  s-maize.middle                 3.4     9.6     6       1.8     2.5
  s-maize.delta                  3.7     8.8     8       1       5
  sorghum.upper                  2.5     7       6       6.5     4.5
  sorghum.middle                 5       6       6       5.5     4
  soyabeans.upper        7      14.5     6       6       7.5     6.5
  soyabeans.middle       7      14.5     6       6       7       5
  soyabeans.delta        3      15.5     6       1       4       6
  groundnut.upper        4.2     5.7     2.1     1       2       2.5
  groundnut.middle       5       6       2       1       4       1
  groundnut.delta        5       5       2       1       3       2
  sesame.upper                   3       5.5     3        .5    10.6
  s-potato.middle        8       5       7       5
  s-potato.delta         9       8       7       4
  s-tomato.upper         3.5     3       3       3
  s-tomato.middle        5.5     5       5       3
  s-tomato.delta         9       8       8       4
  s-veget.upper         10      12      10       5
  s-veget.middle         9      13      11       3
  s-veget.delta         11      11       8       4
  n-maize.upper                                  6.3     6.3     6
  n-maize.middle                                 7       7.5     7
  n-maize.delta                                  5       7.5     5
  n-potato.upper                                        19       5.5
  n-potato.middle                                       16       5.5
  n-potato.delta                                        17       9
  n-tomato.upper                                11.5     3.5     5
  n-tomato.middle                                9.5     5       7
  n-tomato.delta                                11       3       8.5
  n-veget.upper                                 20      15       9
  n-veget.middle                                18      18       9
  n-veget.delta                                 19      16       8
  citrus.upper           2       2.5     1       1       9       1
  citrus.middle          2       3.5     1       1       8.5     1
  citrus.delta           2       2.8     1       1       8.5     1
  sugarcane.upper        5      14.5     8.5    10.5     1.5     1


 Table WaterRequire (crop,zone,month)  water requrements (cm)

                          oct     nov     dec     jan     feb     mar

  lo-berseem.upper                421     439     488     557     707
  lo-berseem.middle               389     427     410     493     560
  lo-berseem.delta                339     372     387     294     559
  sh-berseem.upper        420     439     388     457
  sh-berseem.middle       189     427     410     392
  sh-berseem.delta        139     272     187     294
  wheat.upper                      55     345     352     477     621
  wheat.middle                            267     325     382     373
  wheat.delta                             174     177     176     424
  barley.upper                     76     230     234     298     414
  barley.middle                   178     217     254     382     265
  barley.delta                    116     118     118     289     296
  horse-bean.upper                254     322     258     352     414
  horse-bean.middle               194     246     313     342     361
  horse-bean.delta                 84     229     243     291     340
  lentils.upper                   168     315     420     420     294
  ot-legumes.upper                147     378     441     377     231
  ot-legumes.middle               147     378     441     377     231
  ot-legumes.delta                210     377     336     336     186
  flax.delta                              189     336     356     378
  w-onion.upper                           218     323     362     457
  w-onion.middle                          218     323     362     457
  w-onion.delta                           105     357     324     311
  w-tomato.middle         315     403     541     479
  w-tomato.delta          315     385     490     414
  w-veget.upper           241     521     691     600
  w-veget.middle          241     521     691     600
  w-veget.delta           190     480     530     427
  cotton.upper                                                    260
  cotton.middle                                                   141
  cotton.delta                                                    120
  rice.delta              343
  s-potato.middle                                         211     454
  s-potato.delta                                          211     454
  s-tomato.upper                                          242     521
  s-tomato.middle                                         211     453
  s-tomato.delta                                          209     412
  s-veget.upper                                           270     560
  s-veget.middle                                          270     560
  s-veget.delta                                           208     412
  n-maize.upper           573     113
  n-maize.middle          530     114
  n-maize.delta           464     109
  n-potato.upper          489     479
  n-potato.middle         418     479
  n-potato.delta          370     378
  n-tomato.upper          489     349
  n-tomato.middle         418     479
  n-tomato.delta          369    8.30
  n-veget.upper           200
  n-veget.middle          200
  n-veget.delta           122
  citrus.upper            426     266     212     212     266     373
  citrus.middle           426     266     212     212     266     373
  citrus.delta            392     244     197     195     244     344
  sugarcane.upper         601     403     325     399     376     592

                +         apr     may     jun     jul     aug     sep

  lo-berseem.upper        558
  lo-berseem.middle       314
  lo-berseem.delta        238
  wheat.upper             493
  wheat.middle            397
  wheat.delta             444
  barley.upper            328
  barley.middle            78
  barley.delta             65
  w-onion.upper           119
  w-onion.middle          102
  w-onion.delta           182
  cotton.upper            488     695     518     975     712     154
  cotton.middle           268     473     618     711     363     184
  cotton.delta            262     473     615     711     363     184
  rice.delta                      400    1001    1089    1458    1474
  s-maize.upper                   256     691     999     733     146
  s-maize.middle                  216     640     941     680     146
  s-maize.delta                   213     558     844     692     134
  sorghum.upper                           215     669    1022     827
  sorghum.middle                          215     669    1022     827
  soyabeans.upper                 573     943     892     174
  soyabeans.middle                573     943     892     174
  soyabeans.delta                 493     817     791     149
  groundnut.upper         281     493     569     536     188
  groundnut.middle        281     493     569     536     189
  groundnut.delta         231     420     525     504     188
  sesame.upper                    214     597     648     640
  s-potato.middle         623     588
  s-potato.delta          623     588
  s-tomato.upper          691     600
  s-tomato.middle         623     588
  s-tomato.delta          600     495
  s-veget.upper           720     610
  s-veget.middle          720     610
  s-veget.delta           622     580
  n-maize.upper                                   253     665     752
  n-maize.middle                                  253     665     752
  n-maize.delta                                   248     688     740
  n-potato.upper                                          134     292
  n-potato.middle                                         121     246
  n-potato.delta                                          121     210
  n-tomato.upper                                          134     292
  n-tomato.middle                                         122     246
  n-tomato.delta                                          122     210
  n-veget.upper                                   353     489     280
  n-veget.middle                                  353     489     280
  n-veget.delta                                   310     369     248
  citrus.upper            586     586     667     667     639     533
  citrus.middle           586     586     667     667     639     533
  citrus.delta            541     541     613     614     588     491
  sugarcane.upper         973    1138    1236    1244    1084     818


$Eject

 Table tractor(crop,zone) tractor requirements (tractor hrs per feddan)

                 upper      middle       delta

 lo-berseem      5.600       5.400       5.000
 sh-berseem      3.500       3.000       2.500
 wheat           7.000       6.800       4.000
 barley          7.000       8.000       8.500
 horse-bean      8.000       6.000       5.500
 lentils         8.000
 ot-legumes      5.000       5.000       5.300
 flax                                    4.000
 w-onion         5.500       4.500       6.000
 w-tomato                    4.000       4.500
 w-veget         4.000       3.500       3.700
 cotton          4.200       5.000       6.500
 rice                                    8.000
 s-maize         8.900       9.600       8.500
 sorghum         9.000       8.400
 soyabeans       8.500       8.500       9.000
 sesame          4.800
 s-potato                    5.200       5.400
 s-tomato        8.500       7.800       6.900
 s-veget         6.000       6.500       5.500
 n-maize         6.800       5.600       5.200
 n-potato        6.500       7.000       8.500
 n-tomato        7.800       8.300       9.000
 n-veget         4.800       5.000       4.000
 citrus          4.400       4.000       4.500
 sugarcane      15.000      17.000


$Stitle miscellaneous data

 Table  veg(region,season)  vegetables upper costraints by region

                       winter       summer        nili
*                     (1000'f)     (1000'f)     (1000'f)
       u-egypt          42.0         40.0         50.0
       m-egypt         101.0        114.0        100.0
       e-delta         129.0        154.0        124.0
       m-delta          84.0        117.0         95.0
       w-delta          85.0        180.0        105.0

  Set cup(crop)  crops with upper bound on area/cotton, citrus, sugarcane/
                ;

 Table  upbnds(crop,region) upper bounds on crops by region (1000 feddans)

                u-egypt   m-egypt   e-delta  m-delta   w-delta
   sugarcane      250
   cotton         175        202      341     416       160
   citrus          17         34       75      42        32
      ;

   Alias (region,oregion) ;

 Table  tranc(region,oregion)  transfer cost per ton  (le)

                 m-egypt   e-delta  m-delta

   m-egypt         0.0      6.0       7.0
   e-delta         6.0      0.0       3.0
   m-delta         7.0      3.0       0.0
            ;
 Parameter  los(crop)       factors defining commodity losses in storage
            stran(region,oregion)  transfer costs per ton between regions
            grdfcon(crop)   ratio of dry fodder to total
            dfyld (region,crop)  dry fodder Cropyield
              ;
    los("wheat")  =  .090; los("barley")  = .114; los("horse-bean")= .152;
    los("lentils")=  .188; los("w-tomato")= .100; los("cotton") = .540;
    los("s-maize")=  .049; los("s-tomato")= .100; los("sorghum")= .055;
    los("w-onion")=  .055; los("w-onion") = .057; los("rice")   = .045;
    los("groundnut")=.038; los("s-potato")= .285; los("citrus") = .100;

    grdfcon(FodderCrop)   = 1.0;
    dfyld(region,FodderCrop)=sum(zone$mapzonetoregion(zone,region), FeedYieldFromCrop(FodderCrop,zone)*grdfcon(FodderCrop));
    stran (region,oregion)    =  tranc(region,oregion);

$Stitle linearization of demand function


 Set steps grid /1*10 /
 Scalars  high   factor for maximum price of a commmodity  /1.666/
          low    factor for minimum price of a commodity   / 0.6 /
 Parameter  pe(crop)        commodity export prices (le)
            pm(crop)        commodity import prices (le)
            alpha(crop)     demand curve intercept
            beta(crop)      demand curve gradient
            price(crop)     base price of crop commodities
            pmax(crop)      maximum price for segments
            pmin(crop)      minimum price for segments
            qmax(crop)      maximum national consumption
            qmin(crop)      minimum national consumption
            incr(crop)      increment
            ws(crop,steps)      welfare  segments
            rs(crop,steps)      revenue  definition
            qs(crop,steps)      quantity definition
              ;
  price(crop) =DemandData(crop,"base-p");
  pe(crop)    =DemandData(crop,"export-p");  pm(crop) = DemandData(crop,"import-p");

  beta(Crop_Sold)$DemandData(Crop_Sold,"domes-cons")=DemandData(Crop_Sold,"base-p")/
                              DemandData(Crop_Sold,"domes-cons")/DemandData(Crop_Sold,"elas");
  alpha(Crop_Sold) =DemandData(Crop_Sold,"base-p")-beta(Crop_Sold)*DemandData(Crop_Sold,"domes-cons");
  DemandData(Crop_Sold,"dem-a") =alpha(Crop_Sold);  DemandData(Crop_Sold,"dem-b") = beta(Crop_Sold);
  pmax(Crop_Sold) =  price(Crop_Sold)*high;    pmin(Crop_Sold) = price(Crop_Sold)*low ;
  qmin(Crop_Sold) = (pmax(Crop_Sold)-alpha(Crop_Sold))/beta(Crop_Sold);
  qmax(Crop_Sold) = (pmin(Crop_Sold)-alpha(Crop_Sold))/beta(Crop_Sold);
  incr(Crop_Sold) = (qmax(Crop_Sold)-qmin(Crop_Sold) )/(card(steps)-1);

  qs(Crop_Sold,steps)=qmin(Crop_Sold) + incr(Crop_Sold)*(ord(steps)-1);
  ws(Crop_Sold,steps)=alpha(Crop_Sold)*qs(Crop_Sold,steps)+ .5*beta(Crop_Sold)*sqr(qs(Crop_Sold,steps));
  rs(Crop_Sold,steps)=alpha(Crop_Sold)*qs(Crop_Sold,steps)+    beta(Crop_Sold)*sqr(qs(Crop_Sold,steps));

 Display Crop_Sold,pe,beta,alpha,DemandData;
 Display pmax,pmin,qmax,qmin,incr,qs,ws,rs ;


$Stitle intermediate calculations and reports

 Scalar   day    number of working days per month          / 20 /
          pnfl   cost of one ton of n-fert (local price)   /178 /
          pnfi   cost of one ton of n-fer  (intern price)  /200 /
          ppfl   cost of one ton of p-fer  (local price)   /200 /
          ppfi   cost of one ton of p-fer  (intern price)  /140 /
          ptrl   cost of one tractor hour  (local price)   /1.5 /
          ptri   cost of one tractor hour  (intern price)  /3.0 /
          grdf   green and dry fodder ratio             /.06723 /
          totmd  value of meat and milk (le)            /749576 /
           ;
 Parameter netcs(crop,region)     cost of crop inputs(exl. labor) (le per fedd.)
           RegionWaterAvailr(region,*)   water available at root zone
           eff(region)         efficiency from canbal to root
           prby(crop)        price of by products
           prnut(AnimalNutrients)      cost of artificial protein per ton(le)
           yld(crop,crop,region)     adjusted crop Cropyield matrix (tons per feddan)
           con(crop)         conversion factors for vegetabel oil
                           /cotton .175, soyabeans .175, sesame .470 /
           ;
  Set cnc(crop,crop)   crop reclassification
                 /(maize.     (n-maize, s-maize),
                   s+n-tomato.(s-tomato,n-tomato),
                   potato    .(s-potato,n-potato))/;
*mccarl MAKE ARTIFICIAL PROTEIN VERY EXPENSIVE
  prnut(AnimalNutrients) = 100000000000;
  eff(region)    = 0.6 ;  prby("horse-bean") = 21.75 ; prby("rice") = 5.75 ;

  netcs(crop,region)=(sum(zone$mapzonetoregion(zone,region), tractor(crop,zone)*ptrl )+
                    CropData(crop,"misc") + CropData(crop,"pest") +
                    CropData(crop,"n-fer")*pnfl + ppfl*CropData(crop,"p-fer")-
                    IndusByproduct(crop,region)*prby(crop))$Cropyield(crop,region) ;
  yld(crop,crop,region)            = Cropyield(crop,region) ;
  yld("veg-oil",crop,region)    = Cropyield(crop,region)*con(crop) ;
  yld(Crop_Sold,crop,region)$cnc(Crop_Sold,crop) = Cropyield(crop,region) ;
  yld(crop,crop,region)$sum(Crop_Sold,cnc(Crop_Sold,crop) ) = 0.0 ;


  RegionWaterAvailr(region,month)        = RegionWaterAvail(region,month)*eff(region) ;
  RegionWaterAvailr(region,"total")   = sum(month,RegionWaterAvailr(region,month)) ;

*--    reports

 Parameter rep1(crop,zone,*,*)  report on crop input
              ;
  rep1(crop,zone,"land",month)          =  LandUse(crop,zone,month)               ;
  rep1(crop,zone,"land","total")     =  sum(month, LandUse(crop,zone,month))      ;
  rep1(crop,zone,"water",month)         =  WaterRequire(crop,zone,month)              ;
  rep1(crop,zone,"water","total")    =  sum(month, WaterRequire(crop,zone,month))     ;
  rep1(crop,zone,"LaborRequire",month)        =  LaborRequire(crop,zone,month)             ;
  rep1(crop,zone,"LaborRequire","total")   =  sum(month, LaborRequire(crop,zone,month))    ;

  Display  RegionalData,RegionWaterAvail, RegionWageMen;
  Display  "water - cubic meters per feddan ", rep1;
  Display  Cropyield,yld, netcs ;


$Stitle variables and equations

  Positive Variables
    GROWCROP (region,crop)                           cropping activities(1000's feddans)
    IMPORTS(crop)                                    national IMPORTS    (1000's tons   )
    EXPORTS(crop)                                    national EXPORTS    (1000's tons   )
    DOMESTIC_CONSUME (crop,steps)                    domestic consumption(1000's tons   )
*   NUTRITION_ANIMALS (AnimalNutrients,region)       artificial livestock nutrition - protein and starch (1000's tons)
    TOTAL_PRODUCTION(crop)                           gross production of a commodity
    TRANSPORT(crop,region,oregion)                   straw quantity transfered to the region(1000's tons)
    FODDER_SOURCE(region,crop)                       straw obtained from by products(1000's tons )
    TEMP_LABOR(region,month)                         temporary labor (1000 man months)
    FAMILY_LABOR(region,month)                       family labor (1000 man months)
$IFthen SETGLOBAL ADDART
    ARTCONVEX(crop)                                  artificial variable for convexity constraint
    ART_ANIMAL_NUTRIENT_BAL(AnimalNutrients,region)  artificial variable for animal nutrient constraint
$ENDIF
  Variables
    TOTAL_C_P_SURPLUS                                consumer and producer surplus(1000's le)
             ;

  Equations
     LANDAVAILABLE(region,month)                     land balances (1000 fedds)
     LABORAVAILABLE(region,month)                    labor balance (1000 man months)
     WATERAVAILABLE                                  water constraints
     VEGETABLE_BAL(season,region)                    vegetables constraints
     COMMODITY_BAL(crop)                             commodity balance
     DEMAND_BAL(crop)                                demand balance
     CONVEX(crop)                                    convexity constraints
     GREENFODDER_BAL(region)                         straw balance constraints
     FODDER_BAL(region,crop)                         fodder balance
     ANIMAL_NUTRIENT_BAL(AnimalNutrients,region)     nutrition balance
     OBJECTIVE                                       objective function
      ;

$Stitle equations


 COMMODITY_BAL(Crop_Sold)..
                  TOTAL_PRODUCTION(Crop_Sold)
              =l=
                  sum((region,crop), GROWCROP(region,crop)*yld(Crop_Sold,crop,region));

 DEMAND_BAL(Crop_Sold)..
                  TOTAL_PRODUCTION(Crop_Sold)*(1-los(Crop_Sold))
                 +IMPORTS(Crop_Sold)
              =e=
                  EXPORTS(Crop_Sold)
                 +sum(steps,qs(Crop_Sold,steps)*DOMESTIC_CONSUME(Crop_Sold,steps));

 CONVEX(Crop_Sold)..
                  sum(steps,DOMESTIC_CONSUME(Crop_Sold,steps))
$IFthen SETGLOBAL ADDART
                 +ARTCONVEX(crop_sold)
$ENDIF
              =e=
                  1;

 LANDAVAILABLE(region,month)..
                  sum((crop,zone)$mapzonetoregion(zone,region),GROWCROP(region,crop)*LandUse(crop,zone,month))
              =l=
                  RegionalData(region,"area")    ;

 LABORAVAILABLE(region,month)..
                  sum( (crop,zone)$mapzonetoregion(zone,region),
                         GROWCROP(region,crop)*LaborRequire(crop,zone,month))/day
              =l=
                  TEMP_LABOR(region,month)
                 +FAMILY_LABOR(region,month);

 WATERAVAILABLE..
                  sum(region,
                      sum((crop,month,zone)$mapzonetoregion(zone,region),
                                 GROWCROP(region,crop)*WaterRequire(crop,zone,month) ))
              =l=
                  30000*1000        ;

 VEGETABLE_BAL(season,region)..
                  sum(crop$sv(season,crop), GROWCROP(region,crop))
              =l=
                  veg(region,season)*1.5 ;

*mccarl stopped incoming transport to e_delta
 tranc("e-delta",region)=no;
 FODDER_BAL(region,FodderCrop)..
                  FODDER_SOURCE(region,FodderCrop)
              =e=
                  GROWCROP(region,FodderCrop)
                         *sum(zone$mapzonetoregion(zone,region) ,FeedYieldFromCrop(FodderCrop,zone))
                 +sum(oregion$tranc(region,oregion),
                          TRANSPORT(FodderCrop,oregion,region)
                         -TRANSPORT(FodderCrop,region,oregion))
                         $TransportableFodder(FodderCrop);

 ANIMAL_NUTRIENT_BAL(AnimalNutrients,region)..
                  sum(FodderCrop,FODDER_SOURCE(region,FodderCrop)
                         *CropData(FodderCrop,AnimalNutrients)
                         *.01)
*mccarl remove already resent artificial
*                 +NUTRITION_ANIMALS(AnimalNutrients,region)
$IFthen SETGLOBAL ADDART
                 +ART_ANIMAL_NUTRIENT_BAL(AnimalNutrients,region)
$ENDIF
             =g=
                  RegionalData (region,AnimalNutrients);

 GREENFODDER_BAL (region)..
                  sum(GreenFodder, FODDER_SOURCE(region,GreenFodder))*grdf
             =l=
                  sum(DryFodder, FODDER_SOURCE(region,DryFodder));

  OBJECTIVE..
                  TOTAL_C_P_SURPLUS
              =e=

$IFthen SETGLOBAL ADDART
               0*(
$endif
                  totmd
                 +sum(Crop_Sold,  sum(steps,DOMESTIC_CONSUME(Crop_Sold,steps)*ws(Crop_Sold,steps))
                 +EXPORTS(Crop_Sold)*pe(Crop_Sold)
                 -IMPORTS(Crop_Sold)*pm(Crop_Sold))
                 -sum((TransportableFodder,region,oregion),
                         TRANSPORT(TransportableFodder,region,oregion)*stran(region,oregion))
                 -sum((region,crop),GROWCROP(region,crop)*netcs(crop,region))
*                 -sum((region,AnimalNutrients), NUTRITION_ANIMALS(AnimalNutrients,region)*prnut(AnimalNutrients))
                 -sum((region,month),
                         (  FAMILY_LABOR(region,month)
                          + 2*TEMP_LABOR(region,month))
                         *RegionWageMen(region,month)*day)
$IFTHEN SETGLOBAL ADDART
                )
                -100000*
                        ( sum(crop_sold,ARTCONVEX(crop_sold))
                         +sum((AnimalNutrients,region),ART_ANIMAL_NUTRIENT_BAL(AnimalNutrients,region))
                        )
$eNDIF
                  ;

  Model egypt1 / COMMODITY_BAL, DEMAND_BAL, CONVEX, LANDAVAILABLE,WATERAVAILABLE, VEGETABLE_BAL,
                 FODDER_BAL, GREENFODDER_BAL, ANIMAL_NUTRIENT_BAL, OBJECTIVE, LABORAVAILABLE /;

  Options iterlim=2000 ;

 Table tlimit(crop,*) trade limits (1000 tons)

                      IMPORTS    EXPORTS
  w-onion                          60
  w-tomato                        100
  cotton                          inf
  s+n-tomato                      100
  citrus                          110
  potato                          150
  rice                            300
  wheat                5000
  horse-bean            inf
  maize                 inf
  veg-oil               inf
  lentils               50
     ;
   GROWCROP.up(region,cup) = upbnds(cup,region);
   IMPORTS.up(crop)   = tlimit(crop,"IMPORTS") ;
   EXPORTS.up(crop)   = tlimit(crop,"EXPORTS") ;
   FAMILY_LABOR.up(region,month)    = RegionalData(region,"farmers")*0.4 ;
*$setglobal gamschk
$ifthen setglobal gamschk
  Option LP=GAMSCHK;
  egypt1.optfile=1;
  File opt /gamschk.opt/;
    Put opt
    $$onput
         Margfilt 1
    $$offput
  Putclose;
  File gck /%system.fn%.gck/;
    Put gck
    $$onput
        postopt
        nonopt
    $$offput
  Putclose;
$endif

option limrow=0; option limcol=0;
  Solve egypt1 using lp maximizing TOTAL_C_P_SURPLUS ;


$Stitle report on solution

  Set  s1  headings of total production table
           /crop-area, tot-prod, con-base, IMPORTS, EXPORTS        /
           ;

 Parameter     emply(*,region,*)  employment         (1000's man-month)
               fert                                   total quantity of fertilizer (1000's ton)
               rep3          report on aggrigate economic indicators
               rep2          cropped area report
               rep4          report on gross area etc.
               wateru        water use report
                ;

  emply("farmers",region,month)        = FAMILY_LABOR.l(region,month) ;
  emply("farmers",region,"total")   = sum(month ,FAMILY_LABOR.l(region,month) );
  emply("temp-lab",region,month)       = TEMP_LABOR.l(region,month) ;
  emply("temp-lab",region,"total")  = sum(month ,TEMP_LABOR.l(region,month) );
  wateru(region,month)       = sum((crop,zone)$mapzonetoregion(zone,region),GROWCROP.l(region,crop)*WaterRequire(crop,zone,month));
  wateru(region,"total")  = sum(month ,wateru(region,month));
  fert("p-fert", region)  = sum(crop,GROWCROP.l(region,crop)*CropData(crop,"p-fer")) ;
  fert("p-fert","total") = sum(region,  fert("p-fert",region) );
  fert("n-fert",region)       = sum(crop,GROWCROP.l(region,crop)*CropData(crop,"n-fer")) ;
  fert("n-fert","total") = sum(region,fert("n-fert",region) );

  rep3("TOTAL_C_P_SURPLUS") = TOTAL_C_P_SURPLUS.l ;
  rep3("valpro")     = sum((region,crop),GROWCROP.l(region,crop)*Cropyield(crop,region)
                                                *DemandData(crop,"export-p"));
  rep3("valexp")     = sum(Crop_Sold,EXPORTS.l(Crop_Sold)*pe(Crop_Sold)  )      ;
  rep3("valimp")     = sum(Crop_Sold,IMPORTS.l(Crop_Sold)*pm(Crop_Sold)  )      ;
  rep3("revenue")    = sum(Crop_Sold,sum(steps,DOMESTIC_CONSUME.l(Crop_Sold,steps)*rs(Crop_Sold,steps)))
                       + rep3("valexp")
                       + sum((region,crop),GROWCROP.l(region,crop)*IndusByproduct(crop,region)*prby(crop)) ;

 rep3("yfarm")    = rep3("revenue") -sum((region,crop),GROWCROP.l(region,crop)*netcs(crop,region))
*                   -sum((region,AnimalNutrients),
*                       NUTRITION_ANIMALS.l(AnimalNutrients,region)*prnut(AnimalNutrients))
                    -sum((TransportableFodder,region,oregion),
                    TRANSPORT.l(TransportableFodder,region,oregion)*stran(region,oregion))
                   +sum((region,crop),GROWCROP.l(region,crop)*IndusByproduct(crop,region)*prby(crop)) ;

  rep2(crop,region) = GROWCROP.l(region,crop); rep2(crop,"total") = sum(region, rep2(crop,region)) ;
  rep2("total",region)       =  sum(crop,rep2(crop,region))        ;
  rep2("total","total") =  sum((crop,region),rep2(crop,region))    ;

  rep4(crop, "crop-area" ) =  rep2(crop,"total")         ;
  rep4(crop, "tot-prod"  ) =  TOTAL_PRODUCTION.l(crop)              ;
  rep4(crop, "con-base")   =  DemandData(crop,"domes-cons")  ;
  rep4(Crop_Sold,"IMPORTS"   ) =  IMPORTS.l(Crop_Sold)           ;
  rep4(Crop_Sold,"EXPORTS"   ) =  EXPORTS.l(Crop_Sold)           ;
  rep4("total",s1     ) =  sum(crop,rep4(crop,s1))       ;

 Display emply,fert, rep2,rep3 , rep4 , wateru ;

