from gdxcc import *
import sys

#parse arguments
nrArgs = len(sys.argv)
assert len(sys.argv)>1,"USAGE: jacobian.py gamsSysDir [jacFile] [dictFile]"
sysDir = sys.argv[1]
if nrArgs>2: jacFileIn = sys.argv[2]
else: jacFileIn = "jacobian.gdx"
if nrArgs>3: dictFile = sys.argv[3] 
else: dictFile = "dict.txt"
symA = "A"
jacFileOut = "jac_out.gdx"

#parse dict.txt into symbols list. the indices of the list are equivalent to the uels in the gdx-file
file = open(dictFile,"r")
symbols = []
start = False
for line in file:
    if line.lower().find("equations") != -1: start = True
    elif line.lower().find("variables") != -1: nrEqu = len(symbols)
    elif start: symbols.extend(line.split()[1:])

maxDimEqu, maxDimVar = 1, 1
for i in range(len(symbols)):
    idx1, idx2 = symbols[i].find('('), symbols[i].find(')')
    if idx1 != -1:
        list = [symbols[i][:idx1]]
        list.extend(symbols[i][idx1+1:idx2].split(','))
    else: list = [symbols[i]]
    symbols[i] = list
    #find the maximum dimension for the equations and variables
    if i < nrEqu: maxDimEqu = max(maxDimEqu, len(list))
    else: maxDimVar = max(maxDimVar, len(list))
dim = maxDimEqu+maxDimVar
#add one item at the beginning og the list since the uels start from 1
symbols.insert(0, None)
assert dim<=GMS_MAX_INDEX_DIM, "Too many dimensions. Max dim allowed: "+ str(GMS_MAX_INDEX_DIM)

#read and write the gdx-files
gdxHandleIn = new_gdxHandle_tp()
gdxHandleOut = new_gdxHandle_tp()
assert gdxCreateD(gdxHandleIn, sysDir, GMS_SSSIZE)[0]
assert gdxCreateD(gdxHandleOut, sysDir, GMS_SSSIZE)[0]

ret = gdxOpenRead(gdxHandleIn, jacFileIn)
assert ret[0], gdxErrorStr(gdxHandleIn,ret[1])[1]

assert gdxOpenWrite(gdxHandleOut, jacFileOut, "")[0]
symNr = gdxFindSymbol(gdxHandleIn, symA)[1]
if symNr <=0:
    print "Symbol <", symA, "> was not found."
    sys.exit(2)
nrRecs = gdxDataReadRawStart(gdxHandleIn, symNr)[1]
assert gdxDataWriteStrStart(gdxHandleOut, symA, "", dim, GMS_DT_PAR, 0)

value = doubleArray(5)
for i in range(nrRecs):
    ret = gdxDataReadRaw(gdxHandleIn)
    equ = symbols[ret[1][0]]
    var = symbols[ret[1][1]]
    keys = []
    keys.extend(equ)
    while len(keys)<maxDimEqu:
        keys.append("")
    keys.extend(var)
    while len(keys)<dim:
        keys.append("")
    value[GMS_VAL_LEVEL] = ret[2][GMS_VAL_LEVEL]
    gdxDataWriteStr(gdxHandleOut, keys, value)

#close files and free handles
gdxDataReadDone(gdxHandleIn), gdxDataWriteDone(gdxHandleOut)
gdxClose(gdxHandleIn), gdxClose(gdxHandleOut)
gdxFree(gdxHandleIn), gdxFree(gdxHandleOut)